﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/storagegateway/model/ListCacheReportsResult.h>

#include <utility>

using namespace Aws::StorageGateway::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListCacheReportsResult::ListCacheReportsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListCacheReportsResult& ListCacheReportsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("CacheReportList")) {
    Aws::Utils::Array<JsonView> cacheReportListJsonList = jsonValue.GetArray("CacheReportList");
    for (unsigned cacheReportListIndex = 0; cacheReportListIndex < cacheReportListJsonList.GetLength(); ++cacheReportListIndex) {
      m_cacheReportList.push_back(cacheReportListJsonList[cacheReportListIndex].AsObject());
    }
    m_cacheReportListHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Marker")) {
    m_marker = jsonValue.GetString("Marker");
    m_markerHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
