﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/storagegateway/model/RetrieveTapeArchiveRequest.h>

#include <utility>

using namespace Aws::StorageGateway::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String RetrieveTapeArchiveRequest::SerializePayload() const {
  JsonValue payload;

  if (m_tapeARNHasBeenSet) {
    payload.WithString("TapeARN", m_tapeARN);
  }

  if (m_gatewayARNHasBeenSet) {
    payload.WithString("GatewayARN", m_gatewayARN);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection RetrieveTapeArchiveRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "StorageGateway_20130630.RetrieveTapeArchive"));
  return headers;
}
