﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/supplychain/model/DataIntegrationFlowS3Source.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace SupplyChain {
namespace Model {

DataIntegrationFlowS3Source::DataIntegrationFlowS3Source(JsonView jsonValue) { *this = jsonValue; }

DataIntegrationFlowS3Source& DataIntegrationFlowS3Source::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("bucketName")) {
    m_bucketName = jsonValue.GetString("bucketName");
    m_bucketNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("key")) {
    m_key = jsonValue.GetString("key");
    m_keyHasBeenSet = true;
  }
  return *this;
}

JsonValue DataIntegrationFlowS3Source::Jsonize() const {
  JsonValue payload;

  if (m_bucketNameHasBeenSet) {
    payload.WithString("bucketName", m_bucketName);
  }

  if (m_keyHasBeenSet) {
    payload.WithString("key", m_key);
  }

  return payload;
}

}  // namespace Model
}  // namespace SupplyChain
}  // namespace Aws
