﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/synthetics/model/DeleteCanaryRequest.h>

#include <utility>

using namespace Aws::Synthetics::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String DeleteCanaryRequest::SerializePayload() const { return {}; }

void DeleteCanaryRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_deleteLambdaHasBeenSet) {
    ss << m_deleteLambda;
    uri.AddQueryStringParameter("deleteLambda", ss.str());
    ss.str("");
  }
}
