﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/timestream-query/model/QueryTemporalRangeMax.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace TimestreamQuery {
namespace Model {

QueryTemporalRangeMax::QueryTemporalRangeMax(JsonView jsonValue) { *this = jsonValue; }

QueryTemporalRangeMax& QueryTemporalRangeMax::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Value")) {
    m_value = jsonValue.GetInt64("Value");
    m_valueHasBeenSet = true;
  }
  if (jsonValue.ValueExists("TableArn")) {
    m_tableArn = jsonValue.GetString("TableArn");
    m_tableArnHasBeenSet = true;
  }
  return *this;
}

JsonValue QueryTemporalRangeMax::Jsonize() const {
  JsonValue payload;

  if (m_valueHasBeenSet) {
    payload.WithInt64("Value", m_value);
  }

  if (m_tableArnHasBeenSet) {
    payload.WithString("TableArn", m_tableArn);
  }

  return payload;
}

}  // namespace Model
}  // namespace TimestreamQuery
}  // namespace Aws
