﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/wellarchitected/model/ListLensSharesResult.h>

#include <utility>

using namespace Aws::WellArchitected::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListLensSharesResult::ListLensSharesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListLensSharesResult& ListLensSharesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("LensShareSummaries")) {
    Aws::Utils::Array<JsonView> lensShareSummariesJsonList = jsonValue.GetArray("LensShareSummaries");
    for (unsigned lensShareSummariesIndex = 0; lensShareSummariesIndex < lensShareSummariesJsonList.GetLength();
         ++lensShareSummariesIndex) {
      m_lensShareSummaries.push_back(lensShareSummariesJsonList[lensShareSummariesIndex].AsObject());
    }
    m_lensShareSummariesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
