﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/wellarchitected/model/ListReviewTemplatesResult.h>

#include <utility>

using namespace Aws::WellArchitected::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListReviewTemplatesResult::ListReviewTemplatesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListReviewTemplatesResult& ListReviewTemplatesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("ReviewTemplates")) {
    Aws::Utils::Array<JsonView> reviewTemplatesJsonList = jsonValue.GetArray("ReviewTemplates");
    for (unsigned reviewTemplatesIndex = 0; reviewTemplatesIndex < reviewTemplatesJsonList.GetLength(); ++reviewTemplatesIndex) {
      m_reviewTemplates.push_back(reviewTemplatesJsonList[reviewTemplatesIndex].AsObject());
    }
    m_reviewTemplatesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
