﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/workmail/model/CreateUserRequest.h>

#include <utility>

using namespace Aws::WorkMail::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateUserRequest::SerializePayload() const {
  JsonValue payload;

  if (m_organizationIdHasBeenSet) {
    payload.WithString("OrganizationId", m_organizationId);
  }

  if (m_nameHasBeenSet) {
    payload.WithString("Name", m_name);
  }

  if (m_displayNameHasBeenSet) {
    payload.WithString("DisplayName", m_displayName);
  }

  if (m_passwordHasBeenSet) {
    payload.WithString("Password", m_password);
  }

  if (m_roleHasBeenSet) {
    payload.WithString("Role", UserRoleMapper::GetNameForUserRole(m_role));
  }

  if (m_firstNameHasBeenSet) {
    payload.WithString("FirstName", m_firstName);
  }

  if (m_lastNameHasBeenSet) {
    payload.WithString("LastName", m_lastName);
  }

  if (m_hiddenFromGlobalAddressListHasBeenSet) {
    payload.WithBool("HiddenFromGlobalAddressList", m_hiddenFromGlobalAddressList);
  }

  if (m_identityProviderUserIdHasBeenSet) {
    payload.WithString("IdentityProviderUserId", m_identityProviderUserId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateUserRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "WorkMailService.CreateUser"));
  return headers;
}
