﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/workmail/model/DeleteEmailMonitoringConfigurationRequest.h>

#include <utility>

using namespace Aws::WorkMail::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteEmailMonitoringConfigurationRequest::SerializePayload() const {
  JsonValue payload;

  if (m_organizationIdHasBeenSet) {
    payload.WithString("OrganizationId", m_organizationId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteEmailMonitoringConfigurationRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "WorkMailService.DeleteEmailMonitoringConfiguration"));
  return headers;
}
