﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/workmail/model/GroupIdentifier.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace WorkMail {
namespace Model {

GroupIdentifier::GroupIdentifier(JsonView jsonValue) { *this = jsonValue; }

GroupIdentifier& GroupIdentifier::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("GroupId")) {
    m_groupId = jsonValue.GetString("GroupId");
    m_groupIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("GroupName")) {
    m_groupName = jsonValue.GetString("GroupName");
    m_groupNameHasBeenSet = true;
  }
  return *this;
}

JsonValue GroupIdentifier::Jsonize() const {
  JsonValue payload;

  if (m_groupIdHasBeenSet) {
    payload.WithString("GroupId", m_groupId);
  }

  if (m_groupNameHasBeenSet) {
    payload.WithString("GroupName", m_groupName);
  }

  return payload;
}

}  // namespace Model
}  // namespace WorkMail
}  // namespace Aws
