﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/workspaces/model/ErrorDetails.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace WorkSpaces {
namespace Model {

ErrorDetails::ErrorDetails(JsonView jsonValue) { *this = jsonValue; }

ErrorDetails& ErrorDetails::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("ErrorCode")) {
    m_errorCode = WorkspaceImageErrorDetailCodeMapper::GetWorkspaceImageErrorDetailCodeForName(jsonValue.GetString("ErrorCode"));
    m_errorCodeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ErrorMessage")) {
    m_errorMessage = jsonValue.GetString("ErrorMessage");
    m_errorMessageHasBeenSet = true;
  }
  return *this;
}

JsonValue ErrorDetails::Jsonize() const {
  JsonValue payload;

  if (m_errorCodeHasBeenSet) {
    payload.WithString("ErrorCode", WorkspaceImageErrorDetailCodeMapper::GetNameForWorkspaceImageErrorDetailCode(m_errorCode));
  }

  if (m_errorMessageHasBeenSet) {
    payload.WithString("ErrorMessage", m_errorMessage);
  }

  return payload;
}

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
