﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/workspaces/model/Platform.h>

using namespace Aws::Utils;

namespace Aws {
namespace WorkSpaces {
namespace Model {
namespace PlatformMapper {

static const int WINDOWS_HASH = HashingUtils::HashString("WINDOWS");

Platform GetPlatformForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == WINDOWS_HASH) {
    return Platform::WINDOWS;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<Platform>(hashCode);
  }

  return Platform::NOT_SET;
}

Aws::String GetNameForPlatform(Platform enumValue) {
  switch (enumValue) {
    case Platform::NOT_SET:
      return {};
    case Platform::WINDOWS:
      return "WINDOWS";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace PlatformMapper
}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
