﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/workspaces/model/TerminateWorkspacesPoolRequest.h>

#include <utility>

using namespace Aws::WorkSpaces::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String TerminateWorkspacesPoolRequest::SerializePayload() const {
  JsonValue payload;

  if (m_poolIdHasBeenSet) {
    payload.WithString("PoolId", m_poolId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection TerminateWorkspacesPoolRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "WorkspacesService.TerminateWorkspacesPool"));
  return headers;
}
