/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.Filter;

public class FilterContainer {
    private final List<Filter> m_taskFilters = new ArrayList<Filter>();
    private final List<Filter> m_resourceFilters = new ArrayList<Filter>();
    private final Map<String, Filter> m_filtersByName = new HashMap<String, Filter>();
    private final Map<Integer, Filter> m_filtersByID = new HashMap<Integer, Filter>();

    public void addFilter(Filter filter) {
        if (filter.isTaskFilter()) {
            this.m_taskFilters.add(filter);
        }
        if (filter.isResourceFilter()) {
            this.m_resourceFilters.add(filter);
        }
        this.m_filtersByName.put(filter.getName(), filter);
        this.m_filtersByID.put(filter.getID(), filter);
    }

    public void removeFilter(String filterName) {
        Filter filter = this.getFilterByName(filterName);
        if (filter != null) {
            if (filter.isTaskFilter()) {
                this.m_taskFilters.remove(filter);
            }
            if (filter.isResourceFilter()) {
                this.m_resourceFilters.remove(filter);
            }
            this.m_filtersByName.remove(filterName);
            this.m_filtersByID.remove(filter.getID());
        }
    }

    public List<Filter> getResourceFilters() {
        return this.m_resourceFilters;
    }

    public List<Filter> getTaskFilters() {
        return this.m_taskFilters;
    }

    public Filter getFilterByName(String name) {
        return this.m_filtersByName.get(name);
    }

    public Filter getFilterByID(Integer id) {
        return this.m_filtersByID.get(id);
    }
}

