/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.TimephasedNormaliser;

public abstract class AbstractTimephasedWorkNormaliser
implements TimephasedNormaliser<TimephasedWork> {
    protected void mergeSameWork(List<TimephasedWork> list) {
        ArrayList<TimephasedWork> result = new ArrayList<TimephasedWork>();
        TimephasedItem previousAssignment = null;
        for (TimephasedWork assignment : list) {
            if (previousAssignment == null) {
                assignment.setAmountPerDay(assignment.getTotalAmount());
                result.add(assignment);
            } else {
                Duration previousAssignmentWork = (Duration)previousAssignment.getAmountPerDay();
                Duration assignmentWork = (Duration)assignment.getTotalAmount();
                if (NumberHelper.equals(previousAssignmentWork.getDuration(), assignmentWork.getDuration(), 0.01)) {
                    Date assignmentStart = previousAssignment.getStart();
                    Date assignmentFinish = assignment.getFinish();
                    double total = ((Duration)previousAssignment.getTotalAmount()).getDuration();
                    Duration totalWork = Duration.getInstance(total += assignmentWork.getDuration(), TimeUnit.MINUTES);
                    TimephasedWork merged = new TimephasedWork();
                    merged.setStart(assignmentStart);
                    merged.setFinish(assignmentFinish);
                    merged.setAmountPerDay(assignmentWork);
                    merged.setTotalAmount(totalWork);
                    result.remove(result.size() - 1);
                    assignment = merged;
                } else {
                    assignment.setAmountPerDay(assignment.getTotalAmount());
                }
                result.add(assignment);
            }
            previousAssignment = assignment;
        }
        list.clear();
        list.addAll(result);
    }

    protected void convertToHours(List<TimephasedWork> list) {
        for (TimephasedWork assignment : list) {
            Duration totalWork = (Duration)assignment.getTotalAmount();
            Duration workPerDay = (Duration)assignment.getAmountPerDay();
            totalWork = Duration.getInstance(totalWork.getDuration() / 60.0, TimeUnit.HOURS);
            workPerDay = Duration.getInstance(workPerDay.getDuration() / 60.0, TimeUnit.HOURS);
            assignment.setTotalAmount(totalWork);
            assignment.setAmountPerDay(workPerDay);
        }
    }
}

