/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import net.sf.mpxj.common.ByteArrayHelper;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;

final class Props8
extends Props {
    private boolean m_complete = true;

    Props8(InputStream is) {
        try {
            this.readInt(is);
            this.readInt(is);
            this.readInt(is);
            int count = this.readShort(is);
            this.readShort(is);
            byte[] attrib = new byte[4];
            for (int loop = 0; loop < count; ++loop) {
                int attrib1 = this.readInt(is);
                InputStreamHelper.read(is, attrib);
                int attrib2 = MPPUtility.getInt(attrib, 0);
                int attrib3 = MPPUtility.getByte(attrib, 2);
                int attrib5 = this.readInt(is);
                int size = attrib3 == 64 ? attrib1 : attrib5;
                if (attrib5 == 65536) {
                    size = 4;
                }
                if (size <= 0) {
                    this.m_complete = false;
                    break;
                }
                byte[] data = InputStreamHelper.read(is, size);
                this.m_map.put(attrib2, data);
                if (data.length % 2 == 0) continue;
                InputStreamHelper.skip(is, 1L);
            }
        }
        catch (IOException ex) {
            this.m_complete = false;
        }
    }

    @Override
    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN Props");
        if (this.m_complete) {
            pw.println("   COMPLETE");
        } else {
            pw.println("   INCOMPLETE");
        }
        for (Map.Entry entry : this.m_map.entrySet()) {
            pw.println("   Key: " + entry.getKey() + " Value: " + ByteArrayHelper.hexdump((byte[])entry.getValue(), true));
        }
        pw.println("END Props");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

