/*
 * TaskList.h - TaskJuggler
 *
 * SPDX-FileCopyrightText: 2001, 2002, 2003, 2004 Chris Schlaeger <cs@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * $Id$
 */
#ifndef _TaskList_h_
#define _TaskList_h_

#include "plantj_export.h"

#include "CoreAttributesList.h"

class QString;

namespace TJ
{

class Task;

/**
 * @short The class stores a list of tasks.
 * @see Task
 * @author Chris Schlaeger <cs@kde.org>
 */
class PLANTJ_EXPORT TaskList : public virtual CoreAttributesList
{
public:
    TaskList() :
        CoreAttributesList(),
        sortScenario(0)
    {
        sorting[0] = CoreAttributesList::TreeMode;
        sorting[1] = CoreAttributesList::StartUp;
        sorting[2] = CoreAttributesList::EndUp;
    }

    TaskList(const TaskList& tl) :
        CoreAttributesList(tl),
        sortScenario(tl.sortScenario)
    { }

    ~TaskList() override { }

    Task* getTask(const QString& id) const;

    static bool isSupportedSortingCriteria(int sc);

    int compareItemsLevel(CoreAttributes* c1, CoreAttributes* c2,
                                  int level) override;

    void setSortScenario(int sc) { sortScenario = sc; }

protected:
    int sortScenario;
} ;

/**
 * @short Iterator class for TaskList objects.
 * @see TaskList
 * @author Chris Schlaeger <cs@kde.org>
 */
class PLANTJ_EXPORT TaskListIterator : public virtual CoreAttributesListIterator
{
public:
    explicit TaskListIterator(const CoreAttributesList& l) :
        CoreAttributesListIterator(l) { }
    ~TaskListIterator() override { }
    Task* operator*();
} ;

} // namespace TJ

#endif
