/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.Date;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.Rate;
import net.sf.mpxj.common.DateHelper;

public class CostRateTable
extends ArrayList<CostRateTableEntry> {
    public static final int MAX_TABLES = 5;

    public CostRateTableEntry getEntryByDate(Date date) {
        CostRateTableEntry result = null;
        for (CostRateTableEntry entry : this) {
            if (DateHelper.compare(date, entry.getEndDate()) >= 0) continue;
            result = entry;
            break;
        }
        return result;
    }

    public int getIndexByDate(Date date) {
        int result = -1;
        int index = 0;
        for (CostRateTableEntry entry : this) {
            if (DateHelper.compare(date, entry.getEndDate()) < 0) {
                result = index;
                break;
            }
            ++index;
        }
        return result;
    }

    public boolean tableIsPopulated() {
        return !this.isEmpty() && (this.size() != 1 || !this.allEntriesAreDefault());
    }

    private boolean allEntriesAreDefault() {
        for (CostRateTableEntry entry : this) {
            for (int rateIndex = 0; rateIndex < 5; ++rateIndex) {
                Rate rate = entry.getRate(rateIndex);
                if (rate == null || rate.getAmount() == 0.0) continue;
                return false;
            }
        }
        return true;
    }
}

