/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.util.Locale;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.ConstraintField;
import net.sf.mpxj.DataType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.ProjectField;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.MPPAssignmentField;
import net.sf.mpxj.common.MPPAssignmentField14;
import net.sf.mpxj.common.MPPConstraintField;
import net.sf.mpxj.common.MPPProjectField;
import net.sf.mpxj.common.MPPResourceField;
import net.sf.mpxj.common.MPPResourceField14;
import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.common.MPPTaskField14;
import net.sf.mpxj.common.NumberHelper;

public final class FieldTypeHelper {
    public static int getFieldID(FieldType type) {
        int result;
        if (type == null) {
            result = -1;
        } else {
            switch (type.getFieldTypeClass()) {
                case TASK: {
                    result = 0xB400000 | MPPTaskField.getID((TaskField)type);
                    break;
                }
                case RESOURCE: {
                    result = 0xC400000 | MPPResourceField.getID((ResourceField)type);
                    break;
                }
                case ASSIGNMENT: {
                    result = 0xF400000 | MPPAssignmentField.getID((AssignmentField)type);
                    break;
                }
                case PROJECT: {
                    result = 0xB600000 | MPPProjectField.getID((ProjectField)type);
                    break;
                }
                default: {
                    result = -1;
                }
            }
        }
        return result;
    }

    public static final FieldType getInstance(int fieldID) {
        FieldType result;
        int prefix = fieldID & 0xFFFF0000;
        int index = fieldID & 0xFFFF;
        switch (prefix) {
            case 0xB400000: {
                result = MPPTaskField.getInstance(index);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(TaskField.class, index);
                break;
            }
            case 0xC400000: {
                result = MPPResourceField.getInstance(index);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(ResourceField.class, index);
                break;
            }
            case 0xF400000: {
                result = MPPAssignmentField.getInstance(index);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(AssignmentField.class, index);
                break;
            }
            case 0xD400000: {
                result = MPPConstraintField.getInstance(index);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(ConstraintField.class, index);
                break;
            }
            case 0xB600000: {
                result = MPPProjectField.getInstance(index);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(ProjectField.class, index);
                break;
            }
            default: {
                result = FieldTypeHelper.getPlaceholder(null, index);
            }
        }
        return result;
    }

    public static final FieldType getInstance14(int fieldID) {
        FieldType result;
        int prefix = fieldID & 0xFFFF0000;
        int index = fieldID & 0xFFFF;
        switch (prefix) {
            case 0xB400000: {
                result = MPPTaskField14.getInstance(index);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(TaskField.class, index);
                break;
            }
            case 0xC400000: {
                result = MPPResourceField14.getInstance(index);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(ResourceField.class, index);
                break;
            }
            case 0xF400000: {
                result = MPPAssignmentField14.getInstance(index);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(AssignmentField.class, index);
                break;
            }
            case 0xD400000: {
                result = MPPConstraintField.getInstance(index);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(ConstraintField.class, index);
                break;
            }
            default: {
                result = FieldTypeHelper.getPlaceholder(null, index);
            }
        }
        return result;
    }

    private static FieldType getPlaceholder(final Class<?> type, final int fieldID) {
        return new FieldType(){

            @Override
            public FieldTypeClass getFieldTypeClass() {
                return FieldTypeClass.UNKNOWN;
            }

            @Override
            public String name() {
                return "UNKNOWN";
            }

            @Override
            public int getValue() {
                return fieldID;
            }

            @Override
            public String getName() {
                return "Unknown " + (type == null ? "" : type.getSimpleName() + "(" + fieldID + ")");
            }

            @Override
            public String getName(Locale locale) {
                return this.getName();
            }

            @Override
            public DataType getDataType() {
                return null;
            }

            @Override
            public FieldType getUnitsType() {
                return null;
            }

            public String toString() {
                return this.getName();
            }
        };
    }

    public static FieldType mapTextFields(FieldType field) {
        if (field != null && field.getFieldTypeClass() == FieldTypeClass.TASK) {
            TaskField taskField = (TaskField)field;
            switch (taskField) {
                case START_TEXT: {
                    field = TaskField.START;
                    break;
                }
                case FINISH_TEXT: {
                    field = TaskField.FINISH;
                    break;
                }
                case DURATION_TEXT: {
                    field = TaskField.DURATION;
                    break;
                }
            }
        }
        return field;
    }

    public static final boolean valueIsNotDefault(FieldType type, Object value) {
        boolean result = true;
        if (value == null) {
            result = false;
        } else {
            DataType dataType = type.getDataType();
            switch (dataType) {
                case BOOLEAN: {
                    result = (Boolean)value;
                    break;
                }
                case CURRENCY: 
                case NUMERIC: {
                    result = !NumberHelper.equals(((Number)value).doubleValue(), 0.0, 1.0E-5);
                    break;
                }
                case DURATION: {
                    result = ((Duration)value).getDuration() != 0.0;
                    break;
                }
            }
        }
        return result;
    }
}

