/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.ganttdesigner;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.TimeUnit;

public final class DatatypeConverter {
    private static final ThreadLocal<DateFormat> TIMESTAMP_FORMAT = ThreadLocal.withInitial(() -> {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setLenient(false);
        return df;
    });
    private static final ThreadLocal<DateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setLenient(false);
        return df;
    });

    public static final Date parseTimestamp(String value) {
        Date result = null;
        if (value != null && value.length() != 0) {
            try {
                result = TIMESTAMP_FORMAT.get().parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final String printTimestamp(Date value) {
        return value == null ? null : TIMESTAMP_FORMAT.get().format(value);
    }

    public static final Duration parseDuration(String value) {
        return value == null ? null : Duration.getInstance(Double.parseDouble(value), TimeUnit.DAYS);
    }

    public static final String printDuration(Duration value) {
        return value == null ? null : Double.toString(value.getDuration());
    }

    public static final Date parseDate(String value) {
        Date result = null;
        if (value != null && value.length() != 0) {
            try {
                result = DATE_FORMAT.get().parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final String printDate(Date value) {
        return value == null ? null : DATE_FORMAT.get().format(value);
    }

    public static final Double parsePercent(String value) {
        return value == null ? null : Double.valueOf(Double.parseDouble(value) * 100.0);
    }

    public static final String printPercent(Double value) {
        return value == null ? null : Double.toString(value / 100.0);
    }

    public static final Day parseDay(String value) {
        return Day.getInstance(Integer.parseInt(value) + 1);
    }

    public static final String printDay(Day value) {
        return Integer.toString(value.getValue() - 1);
    }
}

