/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.reader;

import java.beans.Statement;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.ProjectReader;

public abstract class AbstractProjectReader
implements ProjectReader {
    private List<ProjectListener> m_projectListeners;

    @Override
    public ProjectReader setProperties(Properties props) {
        if (props == null) {
            return this;
        }
        String className = this.getClass().getName() + ".";
        props.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(className)).forEach(e -> {
            String methodName = "set" + ((String)e.getKey()).substring(className.length());
            Boolean propertyValue = Boolean.valueOf((String)e.getValue());
            try {
                new Statement(this, methodName, new Object[]{propertyValue}).execute();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return this;
    }

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new ArrayList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    protected void addListenersToProject(ProjectFile project) {
        project.getEventManager().addProjectListeners(this.m_projectListeners);
    }

    protected void addListenersToReader(ProjectReader reader) {
        if (this.m_projectListeners != null) {
            this.m_projectListeners.forEach(reader::addProjectListener);
        }
    }

    @Override
    public void setCharset(Charset charset) {
    }
}

