/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.TimephasedWorkContainer;
import net.sf.mpxj.mspdi.MSPDIWriter;

public class MpxjCreateTimephased {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("Usage: MpxjCreateTimephased <output file name>");
            } else {
                MpxjCreateTimephased.create(args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private static void create(String filename) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        ProjectFile file = new ProjectFile();
        file.addDefaultBaseCalendar();
        ProjectProperties properties = file.getProjectProperties();
        properties.setStartDate(df.parse("01/01/2003 03:00"));
        Resource resource1 = file.addResource();
        resource1.setName("Timephased Resource");
        Task task1 = file.addTask();
        task1.setName("Timephased Task");
        task1.setDuration(Duration.getInstance(3, TimeUnit.DAYS));
        task1.setStart(df.parse("01/01/2003 03:00"));
        task1.setFinish(df.parse("03/01/2003 10:00"));
        ResourceAssignment assignment3 = task1.addResourceAssignment(resource1);
        final TimephasedWork day1 = new TimephasedWork();
        day1.setAmountPerDay(Duration.getInstance(20, TimeUnit.HOURS));
        day1.setStart(df.parse("01/01/2003 03:00"));
        day1.setFinish(df.parse("01/01/2003 23:00"));
        day1.setModified(true);
        day1.setTotalAmount(Duration.getInstance(20, TimeUnit.HOURS));
        final TimephasedWork day2 = new TimephasedWork();
        day2.setAmountPerDay(Duration.getInstance(2, TimeUnit.HOURS));
        day2.setStart(df.parse("02/01/2003 08:00"));
        day2.setFinish(df.parse("02/01/2003 10:00"));
        day2.setModified(true);
        day2.setTotalAmount(Duration.getInstance(2, TimeUnit.HOURS));
        final TimephasedWork day3 = new TimephasedWork();
        day3.setAmountPerDay(Duration.getInstance(2, TimeUnit.HOURS));
        day3.setStart(df.parse("03/01/2003 08:00"));
        day3.setFinish(df.parse("03/01/2003 10:00"));
        day3.setModified(true);
        day3.setTotalAmount(Duration.getInstance(2, TimeUnit.HOURS));
        assignment3.setTimephasedWork(new TimephasedWorkContainer(){

            @Override
            public boolean hasData() {
                return true;
            }

            @Override
            public List<TimephasedWork> getData() {
                return Arrays.asList(day1, day2, day3);
            }

            @Override
            public TimephasedWorkContainer applyFactor(double perDayFactor, double totalFactor) {
                return null;
            }
        });
        MSPDIWriter writer = new MSPDIWriter();
        writer.setWriteTimephasedData(true);
        writer.write(file, filename);
    }
}

