/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.synchro;

import java.io.IOException;
import java.util.Map;
import net.sf.mpxj.synchro.StreamReader;
import net.sf.mpxj.synchro.TableReader;

class UnknownTableReader
extends TableReader {
    private final int m_rowSize;
    private final int m_rowMagicNumber;

    public UnknownTableReader(StreamReader stream) {
        this(stream, 0, 0);
    }

    public UnknownTableReader(StreamReader stream, int rowSize, int rowMagicNumber) {
        super(stream);
        this.m_rowSize = rowSize;
        this.m_rowMagicNumber = rowMagicNumber;
    }

    @Override
    protected void readRow(StreamReader stream, Map<String, Object> map) throws IOException {
        if (this.m_rowSize == 0) {
            throw new IllegalArgumentException("Unexpected records!");
        }
        map.put("UNKNOWN1", stream.readBytes(this.m_rowSize));
    }

    @Override
    protected boolean hasUUID() {
        return false;
    }

    @Override
    protected int rowMagicNumber() {
        return this.m_rowMagicNumber;
    }
}

