/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.fasttrack.FastTrackColumn;
import net.sf.mpxj.fasttrack.FastTrackData;
import net.sf.mpxj.fasttrack.FastTrackField;
import net.sf.mpxj.fasttrack.FastTrackTableType;
import net.sf.mpxj.fasttrack.MapRow;

class FastTrackTable
implements Iterable<MapRow> {
    private final FastTrackData m_data;
    private final FastTrackTableType m_type;
    private final ArrayList<MapRow> m_rows = new ArrayList();

    public FastTrackTable(FastTrackTableType type, FastTrackData data) {
        this.m_data = data;
        this.m_type = type;
    }

    public FastTrackTableType getType() {
        return this.m_type;
    }

    public TimeUnit getDurationTimeUnit() {
        return this.m_data.getDurationTimeUnit();
    }

    public TimeUnit getWorkTimeUnit() {
        return this.m_data.getWorkTimeUnit();
    }

    public void addColumn(FastTrackColumn column) {
        FastTrackField type = column.getType();
        Object[] data = column.getData();
        for (int index = 0; index < data.length; ++index) {
            MapRow row = this.getRow(index);
            row.getMap().put(type, data[index]);
        }
    }

    @Override
    public Iterator<MapRow> iterator() {
        return this.m_rows.iterator();
    }

    private MapRow getRow(int index) {
        MapRow result;
        if (index == this.m_rows.size()) {
            result = new MapRow(this, new HashMap<FastTrackField, Object>());
            this.m_rows.add(result);
        } else {
            result = this.m_rows.get(index);
        }
        return result;
    }
}

