/*
    SPDX-License-Identifier: GPL-2.0-or-later
    SPDX-FileCopyrightText: 2009 Alexander Rieder <alexanderrieder@gmail.com>
    SPDX-FileCopyrightText: 2021-2023 Alexander Semke <alexander.semke@web.de>
*/

#ifndef _TESTOCTAVE_H
#define _TESTOCTAVE_H

#include "backendtest.h"

/** This class test some of the basic functions of the Octave backend
    The different tests represent some general expressions, as well
    as expressions, that are known to have caused problems in earlier
    versions
**/
class TestOctave : public BackendTest
{
  Q_OBJECT

private Q_SLOTS:
    void initTestCase();

    //tests evaluating a simple command
    void testSimpleCommand();
    //tests a command, containing more than 1 line
    void testMultilineCommand();
    //tests if the command queue works correctly
    void testCommandQueue();

    void testVariableDefinition();
    void testMatrixDefinition();

    //comments
    void testComment00();
    void testComment01();
    void testComment02();
    void testComment03();
    void testComment04();
    void testComment05();
    void testComment06();
    void testComment07();
    void testComment08();
    void testComment09();

    //tests a syntax error (not closing bracket)
    void testInvalidSyntax();

    void testHelpRequest();
    void testSyntaxHelp();

    //tests variable model
    void testVariablesCreatingFromCode();
    void testVariablesMultiRowValues();
    void testVariableChangeSizeType();
    void testVariableCleanupAfterRestart();
    void testVariableCreatingFromCodeWithPlot();

    //tests doing a plot
    void testPlot();
    void testCantorPlot2d();
    void testCantorPlot3d();

    void testLoginLogout();
    void testRestartWhileRunning();
private:
    QString backendName() override;
};

#endif /* _TESTOCTAVE_H */
