<!--
    SPDX-FileCopyrightText: 2022 Felipe Kinoshita <kinofhek@gmail.com>
    SPDX-License-Identifier: CC0-1.0
-->

# Fielding

A simple REST API testing tool.

![fielding window](https://cdn.kde.org/screenshots/fielding/fielding.png)

## Features

* Make GET, POST, and other types of HTTP requests.
* Input arbitrary body data.
* Display prettified JSON responses.

## Get It

Details on where to find stable releases of Fielding can be found on it's
[homepage](https://apps.kde.org/fielding).

## Support

If you have an issue with Fielding, please [open a support thread on KDE Discuss](https://discuss.kde.org/c/help/6).

## Building

The easiest way to make changes and test Fielding during development is to [build it with kdesrc-build](https://community.kde.org/Get_Involved/development/Build_software_with_kdesrc-build).

## Contributing

Like other projects in the KDE ecosystem, contributions are welcome from all. This repository is managed in [KDE Invent](https://invent.kde.org/utilities/fielding), our GitLab instance.

* Want to contribute code? See the [GitLab wiki page](https://community.kde.org/Infrastructure/GitLab) for a tutorial on how to send a merge request.
* Reporting a bug? Please submit it on the [KDE Bugtracking System](https://bugs.kde.org/enter_bug.cgi?format=guided&product=fielding). Please do not use the Issues
  tab to report bugs.
* Is there a part of Fielding that's not translated? See the [Getting Involved in Translation wiki page](https://community.kde.org/Get_Involved/translation) to see how
  you can help translate!

If you get stuck or need help with anything at all, head over to the [KDE New Contributors room](https://go.kde.org/matrix/#/#kde-welcome:kde.org) on Matrix. For questions about Fielding, please ask in the [KDE Development room](https://go.kde.org/matrix/#/#kde-devel:kde.org). See [Matrix](https://community.kde.org/Matrix) for more details.

