/*
  SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/
#include "weathertoolplugindialog.h"
#include "weathertoolpluginwidget.h"
#include <QBoxLayout>
#include <QDialogButtonBox>
#include <TextAutoGenerateText/TextAutoGenerateTextToolPlugin>
using namespace Qt::Literals::StringLiterals;
WeatherToolPluginDialog::WeatherToolPluginDialog(TextAutoGenerateText::TextAutoGenerateTextToolPlugin *plugin, QWidget *parent)
    : QDialog(parent)
    , mExampleTextToolPluginWidget(new WeatherToolPluginWidget(plugin, this))
{
    setWindowTitle(plugin ? plugin->displayName() : i18n("Configure Weather Tool Plugin"));

    auto mainLayout = new QVBoxLayout(this);
    mainLayout->setObjectName(u"mainLayout"_s);

    mExampleTextToolPluginWidget->setObjectName(u"mExampleTextToolPluginWidget"_s);
    mainLayout->addWidget(mExampleTextToolPluginWidget);

    auto button = new QDialogButtonBox(QDialogButtonBox::Close, this);
    button->setObjectName(u"button"_s);
    mainLayout->addWidget(button);
    connect(button, &QDialogButtonBox::rejected, this, &WeatherToolPluginDialog::reject);
}

WeatherToolPluginDialog::~WeatherToolPluginDialog() = default;

#include "moc_weathertoolplugindialog.cpp"
