/*
  SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/
#pragma once
#include "textautogenerategenericnetwork_export.h"
#include <QObject>
#include <QString>

class QDebug;
class QJsonObject;
class TEXTAUTOGENERATEGENERICNETWORK_EXPORT GenericNetworkModelAvailableInfo
{
    Q_GADGET
public:
    enum Capability {
        None = 0,
        Vision = 1,
        Audio = 4,
        Ocr = 8,
        Tools = 16,
    };
    Q_DECLARE_FLAGS(Capabilities, Capability)
    Q_FLAG(Capabilities)

    GenericNetworkModelAvailableInfo();
    ~GenericNetworkModelAvailableInfo();
    void parseInfo(const QJsonObject &obj);
    [[nodiscard]] QString description() const;
    void setDescription(const QString &newDescription);

    [[nodiscard]] bool operator==(const GenericNetworkModelAvailableInfo &other) const;

    [[nodiscard]] QString modelName() const;
    void setModelName(const QString &newName);

    [[nodiscard]] bool toolsSupported() const;
    void setToolsSupported(bool newToolsSupported);

    [[nodiscard]] QString modelSize() const;
    void setModelSize(const QString &newModelSize);

    [[nodiscard]] QString identifier() const;
    void setIdentifier(const QString &newIdentifier);

    [[nodiscard]] QString ownedBy() const;
    void setOwnedBy(const QString &newOwnedBy);

    [[nodiscard]] Capabilities capabilities() const;
    void setCapabilities(Capabilities newCapabilities);

private:
    TEXTAUTOGENERATEGENERICNETWORK_NO_EXPORT void parseCapabilities(const QJsonObject &obj);
    Capabilities mCapabilities = Capability::None;
    QString mDescription;
    QString mModelName;
    QString mModelSize;
    QString mIdentifier;
    QString mOwnedBy;
    bool mToolsSupported = false;
    // TODO add tags
};
Q_DECLARE_TYPEINFO(GenericNetworkModelAvailableInfo, Q_RELOCATABLE_TYPE);
TEXTAUTOGENERATEGENERICNETWORK_EXPORT QDebug operator<<(QDebug d, const GenericNetworkModelAvailableInfo &t);
