/*
  SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/
#pragma once

#include "textautogeneratetext_export.h"
#include <QModelIndex>
#include <QWidget>
#include <TextAutoGenerateText/TextAutoGenerateManager>
class QStackedWidget;
namespace TextAutoGenerateText
{
class TextAutoGenerateQuickAskViewWidget;
class TextAutoGenerateNotWorkingWidget;
class TextAutoGenerateNotInstanceFoundWidget;
/**
 * @brief The TextAutoGenerateQuickAskWidget class
 * @author Laurent Montel <montel@kde.org>
 */
class TEXTAUTOGENERATETEXT_EXPORT TextAutoGenerateQuickAskWidget : public QWidget
{
    Q_OBJECT
public:
    explicit TextAutoGenerateQuickAskWidget(TextAutoGenerateText::TextAutoGenerateManager *manager, QWidget *parent = nullptr);
    ~TextAutoGenerateQuickAskWidget() override;

private:
    TEXTAUTOGENERATETEXT_NO_EXPORT void loadEngine();
    TEXTAUTOGENERATETEXT_NO_EXPORT void slotEditingFinished(const TextAutoGenerateText::TextAutoGenerateManager::AskMessageInfo &info,
                                                            const QByteArray &messageUuid);
    TEXTAUTOGENERATETEXT_NO_EXPORT void slotAutogenerateFailed(const QString &str);
    TEXTAUTOGENERATETEXT_NO_EXPORT void slotInitializeDone();
    TEXTAUTOGENERATETEXT_NO_EXPORT void slotNeedToAddInstances();
    TEXTAUTOGENERATETEXT_NO_EXPORT void slotCancelRequest(const QByteArray &uuid);
    TEXTAUTOGENERATETEXT_NO_EXPORT void slotRefreshAnswer(const QByteArray &chatId, const QModelIndex &index);
    TEXTAUTOGENERATETEXT_NO_EXPORT void slotAskMessageRequester(const TextAutoGenerateText::TextAutoGenerateManager::AskMessageInfo &info);
    TEXTAUTOGENERATETEXT_NO_EXPORT void slotConfigureInstances();
    TEXTAUTOGENERATETEXT_NO_EXPORT void updateCurrentPage();
    TEXTAUTOGENERATETEXT_NO_EXPORT void slotEditMessage(const QModelIndex &index);
    TEXTAUTOGENERATETEXT_NO_EXPORT void
    slotEditingFinished2(const QString &str,
                         const QByteArray &messageUuid,
                         const QList<QByteArray> &lstTools,
                         const QList<TextAutoGenerateText::TextAutoGenerateAttachmentUtils::AttachmentElementInfo> &attachmentInfoList);
    QStackedWidget *const mStackedWidget;
    TextAutoGenerateQuickAskViewWidget *const mTextAutoGenerateQuickAskViewWidget;
    TextAutoGenerateNotWorkingWidget *const mTextAutoGenerateNotWorkingWidget;
    TextAutoGenerateNotInstanceFoundWidget *const mTextAutoGenerateNotInstanceFoundWidget;
    TextAutoGenerateManager *const mManager;
    QList<TextAutoGenerateText::TextAutoGenerateManager::AskMessageInfo> mAskMessageList;
    bool mPluginWasInitialized = false;
};
}
