/*
  SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/

#pragma once
#include "textautogeneratetext_export.h"
#include <QDialog>
#include <TextAutoGenerateText/TextAutoGenerateManager>
namespace TextAutoGenerateText
{
class TextAutoGenerateStackWidget;
/**
 * @brief The TextAutoGenerateDialog class
 * @author Laurent Montel <montel@kde.org>
 */
class TEXTAUTOGENERATETEXT_EXPORT TextAutoGenerateDialog : public QDialog
{
    Q_OBJECT
public:
    TextAutoGenerateDialog(TextAutoGenerateText::TextAutoGenerateManager *manager, QWidget *parent);
    explicit TextAutoGenerateDialog(QWidget *parent = nullptr);
    ~TextAutoGenerateDialog() override;

    void ask(const TextAutoGenerateText::TextAutoGenerateManager::AskMessageInfo &info);

private:
    TEXTAUTOGENERATETEXT_NO_EXPORT void readConfig();
    TEXTAUTOGENERATETEXT_NO_EXPORT void writeConfig();
    TextAutoGenerateText::TextAutoGenerateManager *const mTextAutoGenerateManager;
    TextAutoGenerateStackWidget *const mTextAutoGenerateWidget;
};
}
