/*
   SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/
#include "textautogenerateattachmentdelegatehelperimage.h"
#include "core/models/textautogeneratemessagesmodel.h"
#include "widgets/view/textautogeneratedelegateutils.h"
#include <QDebug>
#include <QMimeDatabase>
#include <QPainter>

using namespace TextAutoGenerateText;
using namespace Qt::Literals::StringLiterals;
TextAutoGenerateAttachmentDelegateHelperImage::TextAutoGenerateAttachmentDelegateHelperImage(TextAutoGenerateText::TextAutoGenerateManager *manager,
                                                                                             QObject *parent)
    : TextAutoGenerateAttachmentDelegateHelperBase{manager, parent}
{
}

TextAutoGenerateAttachmentDelegateHelperImage::~TextAutoGenerateAttachmentDelegateHelperImage() = default;

// Name
// Image + hide/show image
void TextAutoGenerateAttachmentDelegateHelperImage::draw(const TextAutoGenerateText::TextAutoGenerateAttachment &msgAttach,
                                                         QPainter *painter,
                                                         QRect attachmentsRect,
                                                         const QModelIndex &index,
                                                         const QStyleOptionViewItem &option) const
{
    const ImageLayout layout = layoutImage(msgAttach, option, attachmentsRect.width(), attachmentsRect.height());
    const TextAutoGenerateMessage::Sender sender = index.data(TextAutoGenerateMessagesModel::SenderRole).value<TextAutoGenerateMessage::Sender>();
    const bool isUser = (sender == TextAutoGenerateMessage::Sender::User);
    const int indent = isUser ? TextAutoGenerateDelegateUtils::marginText() : TextAutoGenerateDelegateUtils::leftLLMIndent();

    const QFont oldFont = painter->font();
    const QFontMetrics fontMetrics(oldFont);
    const int defaultCharHeight = attachmentsRect.bottomLeft().y() + fontMetrics.ascent();
    painter->drawText(attachmentsRect.bottomLeft().x() + indent + layout.pixmap.size().width() + TextAutoGenerateDelegateUtils::spacingText(),
                      defaultCharHeight,
                      layout.name);
    const QIcon hideShowIcon = QIcon::fromTheme(layout.showImage ? u"visibility"_s : u"hint"_s);
#if 0
    hideShowIcon.paint(painter, layout.hideShowButtonRect.translated(messageRect.topLeft()));
#endif
    // Draw image after that.

    // TODO
    qDebug() << " TextAutoGenerateAttachmentDelegateHelperImage::draw";
}

QSize TextAutoGenerateAttachmentDelegateHelperImage::sizeHint(const TextAutoGenerateText::TextAutoGenerateAttachment &msgAttach,
                                                              const QModelIndex &index,
                                                              int maxWidth,
                                                              const QStyleOptionViewItem &option) const
{
    const ImageLayout layout = layoutImage(msgAttach, option, maxWidth, 0);

    return {/*layout.nameSize.width() + */ layout.pixmap.width(), // should be qMax of all sizes, but doesn't really matter
            layout.pixmap.height()};
}

QPoint TextAutoGenerateAttachmentDelegateHelperImage::adaptMousePosition(const QPoint &pos,
                                                                         const TextAutoGenerateAttachment &msgAttach,
                                                                         QRect attachmentsRect,
                                                                         const QStyleOptionViewItem &option)
{
    // TODO
    return pos;
}

TextAutoGenerateAttachmentDelegateHelperImage::ImageLayout
TextAutoGenerateAttachmentDelegateHelperImage::layoutImage(const TextAutoGenerateText::TextAutoGenerateAttachment &msgAttach,
                                                           const QStyleOptionViewItem &option,
                                                           int attachmentsWidth,
                                                           int attachmentsHeight) const
{
    ImageLayout layout;
    layout.mimetype = msgAttach.mimeType();
    layout.name = msgAttach.name();
    const QMimeDatabase db;
    const QMimeType mimeType = db.mimeTypeForName(QString::fromLatin1(layout.mimetype));
    const QString mimeTypeIconName = mimeType.iconName();

    layout.nameSize = option.fontMetrics.size(Qt::TextSingleLine, layout.name);
    // TODO
    return layout;
}

bool TextAutoGenerateAttachmentDelegateHelperImage::handleMouseEvent(const TextAutoGenerateAttachment &msgAttach,
                                                                     QMouseEvent *mouseEvent,
                                                                     QRect attachmentsRect,
                                                                     const QStyleOptionViewItem &option,
                                                                     const QModelIndex &index)
{
    const QEvent::Type eventType = mouseEvent->type();
    switch (eventType) {
    case QEvent::MouseButtonRelease: {
        const QPoint pos = mouseEvent->pos();
        const ImageLayout layout = layoutImage(msgAttach, option, attachmentsRect.width(), attachmentsRect.height());
        break;
    }
    default:
        break;
    }
    return TextAutoGenerateAttachmentDelegateHelperBase::handleMouseEvent(msgAttach, mouseEvent, attachmentsRect, option, index);
}

#include "moc_textautogenerateattachmentdelegatehelperimage.cpp"
