/************************************************************************
 *									*
 *  This file is part of Kooka, a scanning/OCR application using	*
 *  Qt <http://www.qt.io> and KDE Frameworks <http://www.kde.org>.	*
 *									*
 *  Copyright (C) 2021-2024   Jonathan Marten <jjm@keelhaul.me.uk>	*
 *									*
 *  Kooka is free software; you can redistribute it and/or modify it	*
 *  under the terms of the GNU Library General Public License as	*
 *  published by the Free Software Foundation and appearing in the	*
 *  file COPYING included in the packaging of this file;  either	*
 *  version 2 of the License, or (at your option) any later version.	*
 *									*
 *  As a special exception, permission is given to link this program	*
 *  with any version of the KADMOS OCR/ICR engine (a product of		*
 *  reRecognition GmbH, Kreuzlingen), and distribute the resulting	*
 *  executable without including the source code for KADMOS in the	*
 *  source distribution.						*
 *									*
 *  This program is distributed in the hope that it will be useful,	*
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of	*
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	*
 *  GNU General Public License for more details.			*
 *									*
 *  You should have received a copy of the GNU General Public		*
 *  License along with this program;  see the file COPYING.  If		*
 *  not, see <http://www.gnu.org/licenses/>.				*
 *									*
 ************************************************************************/

#ifndef DESTINATIONSAVE_H
#define DESTINATIONSAVE_H

#include "abstractdestination.h"


class DestinationSave : public AbstractDestination
{
    Q_OBJECT

public:
    explicit DestinationSave(QObject *pnt, const QVariantList &args);
    ~DestinationSave() override = default;

    void batchStart(const MultiScanOptions *opts) override;
    bool scanStarting(ScanImage::ImageType type) override;
    bool imageScanned(ScanImage::Ptr img) override;

    MultiScanOptions::Capabilities capabilities() const override;
    KLocalizedString scanDestinationString() override;

    void saveSettings() const override;

private:
    QUrl getSaveLocation(ScanImage::ImageType type, bool allFilters);

private:
    // Indicates that this is the first image arriving in a new batch.
    bool mBatchFirst;

    // If automatic numbering is enabled and a template pattern has
    // been identified, these describe it.
    int mAutoLength;
    QString mAutoPrefix;
    QString mAutoSuffix;

    // The save URL as entered by the user.  Retained literally.
    QUrl mLastUserUrl;
    // The MIME type used to save the previous image.  Retained persistently.
    QString mLastSaveMime;

    // The MIME type selected by the user, that will be used to
    // save the current image.
    QString mSaveMime;

    // The parent directory and the file name to be used to save
    // the current image.
    QUrl mSaveLocation;
    QString mSaveFileName;

    // The next number that will be used for saving.  Retained for efficiency
    // (so that it is not necessary to search starting from 1 every time),
    // unless the destination or template pattern changes.
    int mLastUsedNumber;
};

#endif							// DESTINATIONSAVE_H
