/*
   SPDX-FileCopyrightText: 2013-2026 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#pragma once

#include "messageviewer/headerstyle.h"
#include "messageviewer_export.h"
namespace MessageViewer
{
class PlainHeaderStylePrivate;
/*!
 * \class MessageViewer::PlainHeaderStyle
 * \inmodule MessageViewer
 * \inheaderfile MessageViewer/PlainHeaderStyle
 * \brief The PlainHeaderStyle class
 * \author Laurent Montel <montel@kde.org>
 */
class MESSAGEVIEWER_EXPORT PlainHeaderStyle : public HeaderStyle
{
public:
    /*!
     */
    PlainHeaderStyle();
    /*!
     */
    ~PlainHeaderStyle() override;

public:
    /*!
     */
    const char *name() const override;

    /*!
     */
    [[nodiscard]] QString format(KMime::Message *message) const override;

private:
    std::unique_ptr<PlainHeaderStylePrivate> const d;
};
}
