/*
   SPDX-FileCopyrightText: 2020 Daniel Vrátil <dvratil@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#pragma once

#include "messagecomposer_export.h"
#include "sendlaterjob.h"

#include <Akonadi/Item>

namespace MessageComposer
{
/*!
 * \class MessageComposer::SendLaterRemoveJob
 * \inmodule MessageComposer
 * \inheaderfile MessageComposer/SendLaterRemoveJob
 * \brief Remove a send later job
 */
class MESSAGECOMPOSER_EXPORT SendLaterRemoveJob : public SendLaterJob
{
    Q_OBJECT
public:
    /*! \brief Constructs a SendLaterRemoveJob.
        \param item The Akonadi item ID to remove from the send later queue.
        \param parent The parent object.
    */
    explicit SendLaterRemoveJob(Akonadi::Item::Id item, QObject *parent = nullptr);

protected:
    [[nodiscard]] QDBusPendingReply<> doCall(OrgFreedesktopAkonadiSendLaterAgentInterface *iface) override;
    [[nodiscard]] QString getErrorString(Error error, const QString &detail) const override;

private:
    const Akonadi::Item::Id mItem;
};
}
