/*
 *  SPDX-FileCopyrightText: 2017 Sebastian Gottfried <sebastian.gottfried@posteo.de>
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 */

import QtQuick
import QtQuick.Controls as Controls
import ktouch

Controls.TextField {
    id: control

    property KColorScheme colorScheme: KColorScheme {
        colorGroup: control.enabled? KColorScheme.Active: KColorScheme.Disabled
        colorSet:KColorScheme.View
    }

    property KColorScheme selectionColorScheme: KColorScheme {
        colorGroup: control.enabled? KColorScheme.Active: KColorScheme.Disabled
        colorSet:KColorScheme.Selection
    }

    selectByMouse: true
    selectionColor: selectionColorScheme.normalBackground
    selectedTextColor: selectionColorScheme.normalText

    background: Rectangle {
        color: control.colorScheme.normalBackground
        border.width: 1
        border.color: control.activeFocus?
                          control.colorScheme.focusDecoration:
                          Qt.hsva(control.colorScheme.focusDecoration.hslHue,
                                  0,
                                  control.colorScheme.focusDecoration.hslValue,
                                  control.enabled? 0.5: 0.2)
        Behavior on border.color {
            ColorAnimation { duration: 150 }
        }
    }
}
