/*
  This file is part of Lokalize

  SPDX-FileCopyrightText: 2022 Andreas Cord-Landwehr <cordlandwehr@kde.org>

  SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
*/

#ifndef GETTEXTHEADERPARSER_H
#define GETTEXTHEADERPARSER_H

#include <QString>

/**
 * @brief The GetTextHeaderParser class
 *
 * This class operates on the file header that is represented as a list of lines.
 * The list itself should be generated by splitting the obtained file header by newlines.
 */
class GetTextHeaderParser
{
public:
    static void updateLastTranslator(QStringList &headerList, const QString &authorName, const QString &authorEmail);
    static void updateGeneralCopyrightYear(QStringList &commentList);
    static void updateAuthors(QStringList &commentList, const QString &authorName, const QString &authorEmail);
    static QString joinAuthor(const QString &authorName, const QString &authorEmail);
    /**
     * Parse the copyright line and return updated SPDX compatible license line with updated year
     *
     * This function performs no operation if the current year (due to system time) is already present in string.
     * The returned line is prefixed by a "#" comment marker.
     */
    static QString updateAuthorCopyrightLine(const QString &line);

    static QString simplifyYearString(const QString &years);
    static const QString sCurrentYear;
};

#endif
