// SPDX-FileCopyrightText: 2023 Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: LGPL-2.0-or-later

#pragma once

#include "mimetreeparser_widgets_export.h"

#include <KMime/Message>

#include <QSplitter>
#include <QWidget>

#include <memory>

class QPainter;

namespace MimeTreeParser
{
namespace Widgets
{
/*!
 * \class MimeTreeParser::MessageViewer
 * \inmodule MimeTreeParserWidgets
 * \inheaderfile MimeTreeParserWidgets/MessageViewer
 *
 * \author Carl Schwan <carl.schwan@gnupg.com>
 * \brief MessageViewer that displays the given std::shared_ptr<KMime::Message>
 */
class MIMETREEPARSER_WIDGETS_EXPORT MessageViewer : public QSplitter
{
public:
    /*!
     */
    explicit MessageViewer(QWidget *parent = nullptr);
    /*!
     */
    ~MessageViewer() override;

    /*!
     */
    [[nodiscard]] std::shared_ptr<KMime::Message> message() const;
    /*!
     */
    void setMessage(const std::shared_ptr<KMime::Message> message);

    /// Return whether the viewer should use a fixed size font.
    [[nodiscard]] bool fixedFont() const;
    void setFixedFont(bool checked);

    /// Return the message subject
    [[nodiscard]] QString subject() const;

    /*!
     */
    void print(QPainter *painter, int width);

private:
    class Private;
    std::unique_ptr<Private> d;
};

} // end namespace Widgets
} // end namespace MimeTreeParser
