/*
    SPDX-FileCopyrightText: 2010 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#include "checksumtoolfactory.hpp"

// lib
#include "checksumtool.hpp"

namespace Kasten {

ChecksumToolFactory::ChecksumToolFactory() = default;

ChecksumToolFactory::~ChecksumToolFactory() = default;

std::unique_ptr<AbstractTool> ChecksumToolFactory::create() const
{
    return std::make_unique<ChecksumTool>();
}

}
