/*
    SPDX-FileCopyrightText: 2010, 2011, 2012 Alex Richardson <alex.richardson@gmx.de>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_SCRIPTVALUECONVERTER_HPP
#define KASTEN_SCRIPTVALUECONVERTER_HPP

// Std
#include <memory>
#include <vector>

class QString;
class QScriptValue;
class ScriptLogger;
class DataInformation;

namespace ScriptValueConverter {

// FIXME remove the = 0
/** If the value is one element */
[[nodiscard]]
std::unique_ptr<DataInformation> convert(const QScriptValue& value, const QString& name, ScriptLogger* logger,
                                         DataInformation* parent = nullptr);
/** If the value is a list of elements or an object with many elements */
[[nodiscard]]
std::vector<std::unique_ptr<DataInformation>> convertValues(const QScriptValue& value, ScriptLogger* logger,
                                                            DataInformation* parent = nullptr);

}

#endif /* KASTEN_SCRIPTVALUECONVERTER_HPP */
