/*
    SPDX-FileCopyrightText: 2013 Marco Martin <mart@kde.org>
    SPDX-FileCopyrightText: 2014 Ivan Cukic <ivan.cukic@kde.org>

    SPDX-License-Identifier: LGPL-2.0-or-later
*/

import QtQuick 2.0

import org.kde.plasma.components 3.0 as PlasmaComponents
import org.kde.kirigami 2.20 as Kirigami
import org.kde.config as KConfig  // KAuthorized
import org.kde.kcmutils  // KCMLauncher


FocusScope {
    id: root
    signal closed()

    //this is used to perfectly align the filter field and delegates
    property int cellWidth: Kirigami.Units.iconSizes.sizeForLabels * 30
    property int spacing: 2 * Kirigami.Units.smallSpacing

    property bool showSwitcherOnly: false

    width: Kirigami.Units.gridUnit * 16

    Item {
        id: activityBrowser

        property int spacing: 2 * Kirigami.Units.smallSpacing

        signal closeRequested()

        Keys.onPressed: {
            if (event.key === Qt.Key_Escape) {
                if (heading.searchString.length > 0) {
                    heading.searchString = "";
                } else {
                    activityBrowser.closeRequested();
                }

            } else if (event.key === Qt.Key_Up) {
                activityList.selectPrevious();

            } else if (event.key === Qt.Key_Down) {
                activityList.selectNext();

            } else if (event.key === Qt.Key_Return || event.key === Qt.Key_Enter) {
                activityList.openSelected();

            } else if (event.key === Qt.Key_Tab) {
                // console.log("TAB KEY");

            } else {
                // console.log("OTHER KEY");
                // event.accepted = false;
                // heading.forceActiveFocus();
            }
        }

        // Rectangle {
        //     anchors.fill : parent
        //     opacity      : .4
        //     color        : "white"
        // }

        Heading {
            id: heading

            anchors {
                top: parent.top
                left: parent.left
                right: parent.right

                leftMargin: Kirigami.Units.smallSpacing
                rightMargin: Kirigami.Units.smallSpacing
            }

            visible: !root.showSwitcherOnly

            onCloseRequested: activityBrowser.closeRequested()
        }

        PlasmaComponents.ScrollView {
            anchors {
                top:    heading.visible ? heading.bottom : parent.top
                bottom: bottomPanel.visible ? bottomPanel.top : parent.bottom
                left:   parent.left
                right:  parent.right
                topMargin: activityBrowser.spacing
            }

            ActivityList {
                id: activityList
                showSwitcherOnly: root.showSwitcherOnly
                filterString: heading.searchString.toLowerCase()
                itemsWidth: root.width - Kirigami.Units.smallSpacing
            }
        }

        Item {
            id: bottomPanel

            height: newActivityButton.height + Kirigami.Units.gridUnit

            visible: !root.showSwitcherOnly

            anchors {
                bottom: parent.bottom
                left: parent.left
                right: parent.right
            }

            PlasmaComponents.ToolButton {
                id: newActivityButton

                text: i18nd("plasma_shell_org.kde.plasma.desktop", "Create activity…")
                icon.name: "list-add"

                width: parent.width

                onClicked: KCMLauncher.openSystemSettings("kcm_activities", "newActivity")

                visible: KConfig.KAuthorized.authorize("plasma-desktop/add_activities")
            }
        }

        onCloseRequested: root.closed()

        anchors.fill: parent
    }

}

