// This file was generated by a modified version of qdbusxml2cpp version 0.8
// SPDX-FileCopyrightText: 2025 Carl Schwan <carl@carlschwan.eu>
// SPDX-License-Identifier: LGPL-2.0-or-later

#ifndef SYSTEMD_UNIT_INTERFACE_H
#define SYSTEMD_UNIT_INTERFACE_H

#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtDBus/QtDBus>

/*
 * Proxy class for interface org.freedesktop.systemd1.Unit
 */
class OrgFreedesktopSystemd1UnitInterface : public QDBusAbstractInterface
{
    Q_OBJECT
public:
    static inline const char *staticInterfaceName()
    {
        return "org.freedesktop.systemd1.Unit";
    }

public:
    OrgFreedesktopSystemd1UnitInterface(const QString &service, const QString &path, const QDBusConnection &connection, const char *interface, QObject *parent);

    OrgFreedesktopSystemd1UnitInterface(const QString &service, const QString &path, const QDBusConnection &connection, QObject *parent);

    ~OrgFreedesktopSystemd1UnitInterface();

    Q_PROPERTY(QString AccessSELinuxContext READ accessSELinuxContext NOTIFY accessSELinuxContextChanged)
    inline QString accessSELinuxContext() const
    {
        return qvariant_cast<QString>(property("AccessSELinuxContext"));
    }
    Q_SIGNAL void accessSELinuxContextChanged();

    Q_PROPERTY(QList<QPair<QString, QString>> ActivationDetails READ activationDetails NOTIFY activationDetailsChanged)
    inline QList<QPair<QString, QString>> activationDetails() const
    {
        return qvariant_cast<QList<QPair<QString, QString>>>(property("ActivationDetails"));
    }
    Q_SIGNAL void activationDetailsChanged();

    Q_PROPERTY(qulonglong ActiveEnterTimestamp READ activeEnterTimestamp NOTIFY activeEnterTimestampChanged)
    inline qulonglong activeEnterTimestamp() const
    {
        return qvariant_cast<qulonglong>(property("ActiveEnterTimestamp"));
    }
    Q_SIGNAL void activeEnterTimestampChanged();

    Q_PROPERTY(qulonglong ActiveEnterTimestampMonotonic READ activeEnterTimestampMonotonic NOTIFY activeEnterTimestampMonotonicChanged)
    inline qulonglong activeEnterTimestampMonotonic() const
    {
        return qvariant_cast<qulonglong>(property("ActiveEnterTimestampMonotonic"));
    }
    Q_SIGNAL void activeEnterTimestampMonotonicChanged();

    Q_PROPERTY(qulonglong ActiveExitTimestamp READ activeExitTimestamp NOTIFY activeExitTimestampChanged)
    inline qulonglong activeExitTimestamp() const
    {
        return qvariant_cast<qulonglong>(property("ActiveExitTimestamp"));
    }
    Q_SIGNAL void activeExitTimestampChanged();

    Q_PROPERTY(qulonglong ActiveExitTimestampMonotonic READ activeExitTimestampMonotonic NOTIFY activeExitTimestampMonotonicChanged)
    inline qulonglong activeExitTimestampMonotonic() const
    {
        return qvariant_cast<qulonglong>(property("ActiveExitTimestampMonotonic"));
    }
    Q_SIGNAL void activeExitTimestampMonotonicChanged();

    Q_PROPERTY(QString ActiveState READ activeState NOTIFY activeStateChanged)
    inline QString activeState() const
    {
        return qvariant_cast<QString>(property("ActiveState"));
    }
    Q_SIGNAL void activeStateChanged();

    Q_PROPERTY(QStringList After READ after NOTIFY afterChanged)
    inline QStringList after() const
    {
        return qvariant_cast<QStringList>(property("After"));
    }
    Q_SIGNAL void afterChanged();

    Q_PROPERTY(bool AllowIsolate READ allowIsolate NOTIFY allowIsolateChanged)
    inline bool allowIsolate() const
    {
        return qvariant_cast<bool>(property("AllowIsolate"));
    }
    Q_SIGNAL void allowIsolateChanged();

    Q_PROPERTY(bool AssertResult READ assertResult NOTIFY assertResultChanged)
    inline bool assertResult() const
    {
        return qvariant_cast<bool>(property("AssertResult"));
    }
    Q_SIGNAL void assertResultChanged();

    Q_PROPERTY(qulonglong AssertTimestamp READ assertTimestamp NOTIFY assertTimestampChanged)
    inline qulonglong assertTimestamp() const
    {
        return qvariant_cast<qulonglong>(property("AssertTimestamp"));
    }
    Q_SIGNAL void assertTimestampChanged();

    Q_PROPERTY(qulonglong AssertTimestampMonotonic READ assertTimestampMonotonic NOTIFY assertTimestampMonotonicChanged)
    inline qulonglong assertTimestampMonotonic() const
    {
        return qvariant_cast<qulonglong>(property("AssertTimestampMonotonic"));
    }
    Q_SIGNAL void assertTimestampMonotonicChanged();

    Q_PROPERTY(QVariant Asserts READ asserts NOTIFY assertsChanged)
    inline QVariant asserts() const
    {
        return qvariant_cast<QVariant>(property("Asserts"));
    }
    Q_SIGNAL void assertsChanged();

    Q_PROPERTY(QStringList Before READ before NOTIFY beforeChanged)
    inline QStringList before() const
    {
        return qvariant_cast<QStringList>(property("Before"));
    }
    Q_SIGNAL void beforeChanged();

    Q_PROPERTY(QStringList BindsTo READ bindsTo NOTIFY bindsToChanged)
    inline QStringList bindsTo() const
    {
        return qvariant_cast<QStringList>(property("BindsTo"));
    }
    Q_SIGNAL void bindsToChanged();

    Q_PROPERTY(QStringList BoundBy READ boundBy NOTIFY boundByChanged)
    inline QStringList boundBy() const
    {
        return qvariant_cast<QStringList>(property("BoundBy"));
    }
    Q_SIGNAL void boundByChanged();

    Q_PROPERTY(QStringList CanClean READ canClean NOTIFY canCleanChanged)
    inline QStringList canClean() const
    {
        return qvariant_cast<QStringList>(property("CanClean"));
    }
    Q_SIGNAL void canCleanChanged();

    Q_PROPERTY(bool CanFreeze READ canFreeze NOTIFY canFreezeChanged)
    inline bool canFreeze() const
    {
        return qvariant_cast<bool>(property("CanFreeze"));
    }
    Q_SIGNAL void canFreezeChanged();

    Q_PROPERTY(bool CanIsolate READ canIsolate NOTIFY canIsolateChanged)
    inline bool canIsolate() const
    {
        return qvariant_cast<bool>(property("CanIsolate"));
    }
    Q_SIGNAL void canIsolateChanged();

    Q_PROPERTY(bool CanReload READ canReload NOTIFY canReloadChanged)
    inline bool canReload() const
    {
        return qvariant_cast<bool>(property("CanReload"));
    }
    Q_SIGNAL void canReloadChanged();

    Q_PROPERTY(bool CanStart READ canStart NOTIFY canStartChanged)
    inline bool canStart() const
    {
        return qvariant_cast<bool>(property("CanStart"));
    }
    Q_SIGNAL void canStartChanged();

    Q_PROPERTY(bool CanStop READ canStop NOTIFY canStopChanged)
    inline bool canStop() const
    {
        return qvariant_cast<bool>(property("CanStop"));
    }
    Q_SIGNAL void canStopChanged();

    Q_PROPERTY(QString CollectMode READ collectMode NOTIFY collectModeChanged)
    inline QString collectMode() const
    {
        return qvariant_cast<QString>(property("CollectMode"));
    }
    Q_SIGNAL void collectModeChanged();

    Q_PROPERTY(bool ConditionResult READ conditionResult NOTIFY conditionResultChanged)
    inline bool conditionResult() const
    {
        return qvariant_cast<bool>(property("ConditionResult"));
    }
    Q_SIGNAL void conditionResultChanged();

    Q_PROPERTY(qulonglong ConditionTimestamp READ conditionTimestamp NOTIFY conditionTimestampChanged)
    inline qulonglong conditionTimestamp() const
    {
        return qvariant_cast<qulonglong>(property("ConditionTimestamp"));
    }
    Q_SIGNAL void conditionTimestampChanged();

    Q_PROPERTY(qulonglong ConditionTimestampMonotonic READ conditionTimestampMonotonic NOTIFY conditionTimestampMonotonicChanged)
    inline qulonglong conditionTimestampMonotonic() const
    {
        return qvariant_cast<qulonglong>(property("ConditionTimestampMonotonic"));
    }
    Q_SIGNAL void conditionTimestampMonotonicChanged();

    Q_PROPERTY(QVariant Conditions READ conditions NOTIFY conditionsChanged)
    inline QVariant conditions() const
    {
        return qvariant_cast<QVariant>(property("Conditions"));
    }
    Q_SIGNAL void conditionsChanged();

    Q_PROPERTY(QStringList ConflictedBy READ conflictedBy NOTIFY conflictedByChanged)
    inline QStringList conflictedBy() const
    {
        return qvariant_cast<QStringList>(property("ConflictedBy"));
    }
    Q_SIGNAL void conflictedByChanged();

    Q_PROPERTY(QStringList Conflicts READ conflicts NOTIFY conflictsChanged)
    inline QStringList conflicts() const
    {
        return qvariant_cast<QStringList>(property("Conflicts"));
    }
    Q_SIGNAL void conflictsChanged();

    Q_PROPERTY(QStringList ConsistsOf READ consistsOf NOTIFY consistsOfChanged)
    inline QStringList consistsOf() const
    {
        return qvariant_cast<QStringList>(property("ConsistsOf"));
    }
    Q_SIGNAL void consistsOfChanged();

    Q_PROPERTY(bool DefaultDependencies READ defaultDependencies NOTIFY defaultDependenciesChanged)
    inline bool defaultDependencies() const
    {
        return qvariant_cast<bool>(property("DefaultDependencies"));
    }
    Q_SIGNAL void defaultDependenciesChanged();

    Q_PROPERTY(QString Description READ description NOTIFY descriptionChanged)
    inline QString description() const
    {
        return qvariant_cast<QString>(property("Description"));
    }
    Q_SIGNAL void descriptionChanged();

    Q_PROPERTY(QStringList Documentation READ documentation NOTIFY documentationChanged)
    inline QStringList documentation() const
    {
        return qvariant_cast<QStringList>(property("Documentation"));
    }
    Q_SIGNAL void documentationChanged();

    Q_PROPERTY(QStringList DropInPaths READ dropInPaths NOTIFY dropInPathsChanged)
    inline QStringList dropInPaths() const
    {
        return qvariant_cast<QStringList>(property("DropInPaths"));
    }
    Q_SIGNAL void dropInPathsChanged();

    Q_PROPERTY(QString FailureAction READ failureAction NOTIFY failureActionChanged)
    inline QString failureAction() const
    {
        return qvariant_cast<QString>(property("FailureAction"));
    }
    Q_SIGNAL void failureActionChanged();

    Q_PROPERTY(int FailureActionExitStatus READ failureActionExitStatus NOTIFY failureActionExitStatusChanged)
    inline int failureActionExitStatus() const
    {
        return qvariant_cast<int>(property("FailureActionExitStatus"));
    }
    Q_SIGNAL void failureActionExitStatusChanged();

    Q_PROPERTY(QString Following READ following NOTIFY followingChanged)
    inline QString following() const
    {
        return qvariant_cast<QString>(property("Following"));
    }
    Q_SIGNAL void followingChanged();

    Q_PROPERTY(QString FragmentPath READ fragmentPath NOTIFY fragmentPathChanged)
    inline QString fragmentPath() const
    {
        return qvariant_cast<QString>(property("FragmentPath"));
    }
    Q_SIGNAL void fragmentPathChanged();

    Q_PROPERTY(QString FreezerState READ freezerState NOTIFY freezerStateChanged)
    inline QString freezerState() const
    {
        return qvariant_cast<QString>(property("FreezerState"));
    }
    Q_SIGNAL void freezerStateChanged();

    Q_PROPERTY(QString Id READ id NOTIFY idChanged)
    inline QString id() const
    {
        return qvariant_cast<QString>(property("Id"));
    }
    Q_SIGNAL void idChanged();

    Q_PROPERTY(bool IgnoreOnIsolate READ ignoreOnIsolate NOTIFY ignoreOnIsolateChanged)
    inline bool ignoreOnIsolate() const
    {
        return qvariant_cast<bool>(property("IgnoreOnIsolate"));
    }
    Q_SIGNAL void ignoreOnIsolateChanged();

    Q_PROPERTY(qulonglong InactiveEnterTimestamp READ inactiveEnterTimestamp NOTIFY inactiveEnterTimestampChanged)
    inline qulonglong inactiveEnterTimestamp() const
    {
        return qvariant_cast<qulonglong>(property("InactiveEnterTimestamp"));
    }
    Q_SIGNAL void inactiveEnterTimestampChanged();

    Q_PROPERTY(qulonglong InactiveEnterTimestampMonotonic READ inactiveEnterTimestampMonotonic NOTIFY inactiveEnterTimestampMonotonicChanged)
    inline qulonglong inactiveEnterTimestampMonotonic() const
    {
        return qvariant_cast<qulonglong>(property("InactiveEnterTimestampMonotonic"));
    }
    Q_SIGNAL void inactiveEnterTimestampMonotonicChanged();

    Q_PROPERTY(qulonglong InactiveExitTimestamp READ inactiveExitTimestamp NOTIFY inactiveExitTimestampChanged)
    inline qulonglong inactiveExitTimestamp() const
    {
        return qvariant_cast<qulonglong>(property("InactiveExitTimestamp"));
    }
    Q_SIGNAL void inactiveExitTimestampChanged();

    Q_PROPERTY(qulonglong InactiveExitTimestampMonotonic READ inactiveExitTimestampMonotonic NOTIFY inactiveExitTimestampMonotonicChanged)
    inline qulonglong inactiveExitTimestampMonotonic() const
    {
        return qvariant_cast<qulonglong>(property("InactiveExitTimestampMonotonic"));
    }
    Q_SIGNAL void inactiveExitTimestampMonotonicChanged();

    Q_PROPERTY(QByteArray InvocationID READ invocationID NOTIFY invocationIDChanged)
    inline QByteArray invocationID() const
    {
        return qvariant_cast<QByteArray>(property("InvocationID"));
    }
    Q_SIGNAL void invocationIDChanged();

    Q_PROPERTY(QPair<uint, QDBusObjectPath> Job READ job NOTIFY jobChanged)
    inline QPair<uint, QDBusObjectPath> job() const
    {
        return qvariant_cast<QPair<uint, QDBusObjectPath>>(property("Job"));
    }
    Q_SIGNAL void jobChanged();

    Q_PROPERTY(qulonglong JobRunningTimeoutUSec READ jobRunningTimeoutUSec NOTIFY jobRunningTimeoutUSecChanged)
    inline qulonglong jobRunningTimeoutUSec() const
    {
        return qvariant_cast<qulonglong>(property("JobRunningTimeoutUSec"));
    }
    Q_SIGNAL void jobRunningTimeoutUSecChanged();

    Q_PROPERTY(QString JobTimeoutAction READ jobTimeoutAction NOTIFY jobTimeoutActionChanged)
    inline QString jobTimeoutAction() const
    {
        return qvariant_cast<QString>(property("JobTimeoutAction"));
    }
    Q_SIGNAL void jobTimeoutActionChanged();

    Q_PROPERTY(QString JobTimeoutRebootArgument READ jobTimeoutRebootArgument NOTIFY jobTimeoutRebootArgumentChanged)
    inline QString jobTimeoutRebootArgument() const
    {
        return qvariant_cast<QString>(property("JobTimeoutRebootArgument"));
    }
    Q_SIGNAL void jobTimeoutRebootArgumentChanged();

    Q_PROPERTY(qulonglong JobTimeoutUSec READ jobTimeoutUSec NOTIFY jobTimeoutUSecChanged)
    inline qulonglong jobTimeoutUSec() const
    {
        return qvariant_cast<qulonglong>(property("JobTimeoutUSec"));
    }
    Q_SIGNAL void jobTimeoutUSecChanged();

    Q_PROPERTY(QStringList JoinsNamespaceOf READ joinsNamespaceOf NOTIFY joinsNamespaceOfChanged)
    inline QStringList joinsNamespaceOf() const
    {
        return qvariant_cast<QStringList>(property("JoinsNamespaceOf"));
    }
    Q_SIGNAL void joinsNamespaceOfChanged();

    Q_PROPERTY(QPair<QString, QString> LoadError READ loadError NOTIFY loadErrorChanged)
    inline QPair<QString, QString> loadError() const
    {
        return qvariant_cast<QPair<QString, QString>>(property("LoadError"));
    }
    Q_SIGNAL void loadErrorChanged();

    Q_PROPERTY(QString LoadState READ loadState NOTIFY loadStateChanged)
    inline QString loadState() const
    {
        return qvariant_cast<QString>(property("LoadState"));
    }
    Q_SIGNAL void loadStateChanged();

    Q_PROPERTY(QStringList Markers READ markers NOTIFY markersChanged)
    inline QStringList markers() const
    {
        return qvariant_cast<QStringList>(property("Markers"));
    }
    Q_SIGNAL void markersChanged();

    Q_PROPERTY(QStringList Names READ names NOTIFY namesChanged)
    inline QStringList names() const
    {
        return qvariant_cast<QStringList>(property("Names"));
    }
    Q_SIGNAL void namesChanged();

    Q_PROPERTY(bool NeedDaemonReload READ needDaemonReload NOTIFY needDaemonReloadChanged)
    inline bool needDaemonReload() const
    {
        return qvariant_cast<bool>(property("NeedDaemonReload"));
    }
    Q_SIGNAL void needDaemonReloadChanged();

    Q_PROPERTY(QStringList OnFailure READ onFailure NOTIFY onFailureChanged)
    inline QStringList onFailure() const
    {
        return qvariant_cast<QStringList>(property("OnFailure"));
    }
    Q_SIGNAL void onFailureChanged();

    Q_PROPERTY(QString OnFailureJobMode READ onFailureJobMode NOTIFY onFailureJobModeChanged)
    inline QString onFailureJobMode() const
    {
        return qvariant_cast<QString>(property("OnFailureJobMode"));
    }
    Q_SIGNAL void onFailureJobModeChanged();

    Q_PROPERTY(QStringList OnFailureOf READ onFailureOf NOTIFY onFailureOfChanged)
    inline QStringList onFailureOf() const
    {
        return qvariant_cast<QStringList>(property("OnFailureOf"));
    }
    Q_SIGNAL void onFailureOfChanged();

    Q_PROPERTY(QStringList OnSuccess READ onSuccess NOTIFY onSuccessChanged)
    inline QStringList onSuccess() const
    {
        return qvariant_cast<QStringList>(property("OnSuccess"));
    }
    Q_SIGNAL void onSuccessChanged();

    Q_PROPERTY(QString OnSuccessJobMode READ onSuccessJobMode NOTIFY onSuccessJobModeChanged)
    inline QString onSuccessJobMode() const
    {
        return qvariant_cast<QString>(property("OnSuccessJobMode"));
    }
    Q_SIGNAL void onSuccessJobModeChanged();

    Q_PROPERTY(QStringList OnSuccessOf READ onSuccessOf NOTIFY onSuccessOfChanged)
    inline QStringList onSuccessOf() const
    {
        return qvariant_cast<QStringList>(property("OnSuccessOf"));
    }
    Q_SIGNAL void onSuccessOfChanged();

    Q_PROPERTY(QStringList PartOf READ partOf NOTIFY partOfChanged)
    inline QStringList partOf() const
    {
        return qvariant_cast<QStringList>(property("PartOf"));
    }
    Q_SIGNAL void partOfChanged();

    Q_PROPERTY(bool Perpetual READ perpetual NOTIFY perpetualChanged)
    inline bool perpetual() const
    {
        return qvariant_cast<bool>(property("Perpetual"));
    }
    Q_SIGNAL void perpetualChanged();

    Q_PROPERTY(QStringList PropagatesReloadTo READ propagatesReloadTo NOTIFY propagatesReloadToChanged)
    inline QStringList propagatesReloadTo() const
    {
        return qvariant_cast<QStringList>(property("PropagatesReloadTo"));
    }
    Q_SIGNAL void propagatesReloadToChanged();

    Q_PROPERTY(QStringList PropagatesStopTo READ propagatesStopTo NOTIFY propagatesStopToChanged)
    inline QStringList propagatesStopTo() const
    {
        return qvariant_cast<QStringList>(property("PropagatesStopTo"));
    }
    Q_SIGNAL void propagatesStopToChanged();

    Q_PROPERTY(QString RebootArgument READ rebootArgument NOTIFY rebootArgumentChanged)
    inline QString rebootArgument() const
    {
        return qvariant_cast<QString>(property("RebootArgument"));
    }
    Q_SIGNAL void rebootArgumentChanged();

    Q_PROPERTY(QStringList Refs READ refs NOTIFY refsChanged)
    inline QStringList refs() const
    {
        return qvariant_cast<QStringList>(property("Refs"));
    }
    Q_SIGNAL void refsChanged();

    Q_PROPERTY(bool RefuseManualStart READ refuseManualStart NOTIFY refuseManualStartChanged)
    inline bool refuseManualStart() const
    {
        return qvariant_cast<bool>(property("RefuseManualStart"));
    }
    Q_SIGNAL void refuseManualStartChanged();

    Q_PROPERTY(bool RefuseManualStop READ refuseManualStop NOTIFY refuseManualStopChanged)
    inline bool refuseManualStop() const
    {
        return qvariant_cast<bool>(property("RefuseManualStop"));
    }
    Q_SIGNAL void refuseManualStopChanged();

    Q_PROPERTY(QStringList ReloadPropagatedFrom READ reloadPropagatedFrom NOTIFY reloadPropagatedFromChanged)
    inline QStringList reloadPropagatedFrom() const
    {
        return qvariant_cast<QStringList>(property("ReloadPropagatedFrom"));
    }
    Q_SIGNAL void reloadPropagatedFromChanged();

    Q_PROPERTY(QStringList RequiredBy READ requiredBy NOTIFY requiredByChanged)
    inline QStringList requiredBy() const
    {
        return qvariant_cast<QStringList>(property("RequiredBy"));
    }
    Q_SIGNAL void requiredByChanged();

    Q_PROPERTY(QStringList Requires READ requireDependencies NOTIFY requiresChanged)
    inline QStringList requireDependencies() const
    {
        return qvariant_cast<QStringList>(property("Requires"));
    }
    Q_SIGNAL void requiresChanged();

    Q_PROPERTY(QStringList RequiresMountsFor READ requiresMountsFor NOTIFY requiresMountsForChanged)
    inline QStringList requiresMountsFor() const
    {
        return qvariant_cast<QStringList>(property("RequiresMountsFor"));
    }
    Q_SIGNAL void requiresMountsForChanged();

    Q_PROPERTY(QStringList Requisite READ requisite NOTIFY requisiteChanged)
    inline QStringList requisite() const
    {
        return qvariant_cast<QStringList>(property("Requisite"));
    }
    Q_SIGNAL void requisiteChanged();

    Q_PROPERTY(QStringList RequisiteOf READ requisiteOf NOTIFY requisiteOfChanged)
    inline QStringList requisiteOf() const
    {
        return qvariant_cast<QStringList>(property("RequisiteOf"));
    }
    Q_SIGNAL void requisiteOfChanged();

    Q_PROPERTY(QStringList SliceOf READ sliceOf NOTIFY sliceOfChanged)
    inline QStringList sliceOf() const
    {
        return qvariant_cast<QStringList>(property("SliceOf"));
    }
    Q_SIGNAL void sliceOfChanged();

    Q_PROPERTY(QString SourcePath READ sourcePath NOTIFY sourcePathChanged)
    inline QString sourcePath() const
    {
        return qvariant_cast<QString>(property("SourcePath"));
    }
    Q_SIGNAL void sourcePathChanged();

    Q_PROPERTY(QString StartLimitAction READ startLimitAction NOTIFY startLimitActionChanged)
    inline QString startLimitAction() const
    {
        return qvariant_cast<QString>(property("StartLimitAction"));
    }
    Q_SIGNAL void startLimitActionChanged();

    Q_PROPERTY(uint StartLimitBurst READ startLimitBurst NOTIFY startLimitBurstChanged)
    inline uint startLimitBurst() const
    {
        return qvariant_cast<uint>(property("StartLimitBurst"));
    }
    Q_SIGNAL void startLimitBurstChanged();

    Q_PROPERTY(qulonglong StartLimitIntervalUSec READ startLimitIntervalUSec NOTIFY startLimitIntervalUSecChanged)
    inline qulonglong startLimitIntervalUSec() const
    {
        return qvariant_cast<qulonglong>(property("StartLimitIntervalUSec"));
    }
    Q_SIGNAL void startLimitIntervalUSecChanged();

    Q_PROPERTY(qulonglong StateChangeTimestamp READ stateChangeTimestamp NOTIFY stateChangeTimestampChanged)
    inline qulonglong stateChangeTimestamp() const
    {
        return qvariant_cast<qulonglong>(property("StateChangeTimestamp"));
    }
    Q_SIGNAL void stateChangeTimestampChanged();

    Q_PROPERTY(qulonglong StateChangeTimestampMonotonic READ stateChangeTimestampMonotonic NOTIFY stateChangeTimestampMonotonicChanged)
    inline qulonglong stateChangeTimestampMonotonic() const
    {
        return qvariant_cast<qulonglong>(property("StateChangeTimestampMonotonic"));
    }
    Q_SIGNAL void stateChangeTimestampMonotonicChanged();

    Q_PROPERTY(QStringList StopPropagatedFrom READ stopPropagatedFrom NOTIFY stopPropagatedFromChanged)
    inline QStringList stopPropagatedFrom() const
    {
        return qvariant_cast<QStringList>(property("StopPropagatedFrom"));
    }
    Q_SIGNAL void stopPropagatedFromChanged();

    Q_PROPERTY(bool StopWhenUnneeded READ stopWhenUnneeded NOTIFY stopWhenUnneededChanged)
    inline bool stopWhenUnneeded() const
    {
        return qvariant_cast<bool>(property("StopWhenUnneeded"));
    }
    Q_SIGNAL void stopWhenUnneededChanged();

    Q_PROPERTY(QString SubState READ subState NOTIFY subStateChanged)
    inline QString subState() const
    {
        return qvariant_cast<QString>(property("SubState"));
    }
    Q_SIGNAL void subStateChanged();

    Q_PROPERTY(QString SuccessAction READ successAction NOTIFY successActionChanged)
    inline QString successAction() const
    {
        return qvariant_cast<QString>(property("SuccessAction"));
    }
    Q_SIGNAL void successActionChanged();

    Q_PROPERTY(int SuccessActionExitStatus READ successActionExitStatus NOTIFY successActionExitStatusChanged)
    inline int successActionExitStatus() const
    {
        return qvariant_cast<int>(property("SuccessActionExitStatus"));
    }
    Q_SIGNAL void successActionExitStatusChanged();

    Q_PROPERTY(bool SurviveFinalKillSignal READ surviveFinalKillSignal NOTIFY surviveFinalKillSignalChanged)
    inline bool surviveFinalKillSignal() const
    {
        return qvariant_cast<bool>(property("SurviveFinalKillSignal"));
    }
    Q_SIGNAL void surviveFinalKillSignalChanged();

    Q_PROPERTY(bool Transient READ transient NOTIFY transientChanged)
    inline bool transient() const
    {
        return qvariant_cast<bool>(property("Transient"));
    }
    Q_SIGNAL void transientChanged();

    Q_PROPERTY(QStringList TriggeredBy READ triggeredBy NOTIFY triggeredByChanged)
    inline QStringList triggeredBy() const
    {
        return qvariant_cast<QStringList>(property("TriggeredBy"));
    }
    Q_SIGNAL void triggeredByChanged();

    Q_PROPERTY(QStringList Triggers READ triggers NOTIFY triggersChanged)
    inline QStringList triggers() const
    {
        return qvariant_cast<QStringList>(property("Triggers"));
    }
    Q_SIGNAL void triggersChanged();

    Q_PROPERTY(QString UnitFilePreset READ unitFilePreset NOTIFY unitFilePresetChanged)
    inline QString unitFilePreset() const
    {
        return qvariant_cast<QString>(property("UnitFilePreset"));
    }
    Q_SIGNAL void unitFilePresetChanged();

    Q_PROPERTY(QString UnitFileState READ unitFileState NOTIFY unitFileStateChanged)
    inline QString unitFileState() const
    {
        return qvariant_cast<QString>(property("UnitFileState"));
    }
    Q_SIGNAL void unitFileStateChanged();

    Q_PROPERTY(QStringList UpheldBy READ upheldBy NOTIFY upheldByChanged)
    inline QStringList upheldBy() const
    {
        return qvariant_cast<QStringList>(property("UpheldBy"));
    }
    Q_SIGNAL void upheldByChanged();

    Q_PROPERTY(QStringList Upholds READ upholds NOTIFY upholdsChanged)
    inline QStringList upholds() const
    {
        return qvariant_cast<QStringList>(property("Upholds"));
    }
    Q_SIGNAL void upholdsChanged();

    Q_PROPERTY(QStringList WantedBy READ wantedBy NOTIFY wantedByChanged)
    inline QStringList wantedBy() const
    {
        return qvariant_cast<QStringList>(property("WantedBy"));
    }
    Q_SIGNAL void wantedByChanged();

    Q_PROPERTY(QStringList Wants READ wants NOTIFY wantsChanged)
    inline QStringList wants() const
    {
        return qvariant_cast<QStringList>(property("Wants"));
    }
    Q_SIGNAL void wantsChanged();

public Q_SLOTS: // METHODS
    inline QDBusPendingReply<> Clean(const QStringList &mask)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(mask);
        return asyncCallWithArgumentList(QStringLiteral("Clean"), argumentList);
    }

    inline QDBusPendingReply<uint, QDBusObjectPath, QString, QDBusObjectPath, QString, QVariantMap> EnqueueJob(const QString &job_type, const QString &job_mode)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(job_type) << QVariant::fromValue(job_mode);
        return asyncCallWithArgumentList(QStringLiteral("EnqueueJob"), argumentList);
    }
    inline QDBusReply<uint> EnqueueJob(const QString &job_type,
                                       const QString &job_mode,
                                       QDBusObjectPath &job_path,
                                       QString &unit_id,
                                       QDBusObjectPath &unit_path,
                                       QString &job_type_,
                                       QVariantMap &affected_jobs)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(job_type) << QVariant::fromValue(job_mode);
        QDBusMessage reply = callWithArgumentList(QDBus::Block, QStringLiteral("EnqueueJob"), argumentList);
        if (reply.type() == QDBusMessage::ReplyMessage && reply.arguments().size() == 6) {
            job_path = qdbus_cast<QDBusObjectPath>(reply.arguments().at(1));
            unit_id = qdbus_cast<QString>(reply.arguments().at(2));
            unit_path = qdbus_cast<QDBusObjectPath>(reply.arguments().at(3));
            job_type_ = qdbus_cast<QString>(reply.arguments().at(4));
            affected_jobs = qdbus_cast<QVariantMap>(reply.arguments().at(5));
        }
        return reply;
    }

    inline QDBusPendingReply<> Freeze()
    {
        QList<QVariant> argumentList;
        return asyncCallWithArgumentList(QStringLiteral("Freeze"), argumentList);
    }

    inline QDBusPendingReply<> Kill(const QString &whom, int signal)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(whom) << QVariant::fromValue(signal);
        return asyncCallWithArgumentList(QStringLiteral("Kill"), argumentList);
    }

    inline QDBusPendingReply<> QueueSignal(const QString &whom, int signal, int value)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(whom) << QVariant::fromValue(signal) << QVariant::fromValue(value);
        return asyncCallWithArgumentList(QStringLiteral("QueueSignal"), argumentList);
    }

    inline QDBusPendingReply<> Ref()
    {
        QList<QVariant> argumentList;
        return asyncCallWithArgumentList(QStringLiteral("Ref"), argumentList);
    }

    inline QDBusPendingReply<QDBusObjectPath> Reload(const QString &mode)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(mode);
        return asyncCallWithArgumentList(QStringLiteral("Reload"), argumentList);
    }

    inline QDBusPendingReply<QDBusObjectPath> ReloadOrRestart(const QString &mode)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(mode);
        return asyncCallWithArgumentList(QStringLiteral("ReloadOrRestart"), argumentList);
    }

    inline QDBusPendingReply<QDBusObjectPath> ReloadOrTryRestart(const QString &mode)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(mode);
        return asyncCallWithArgumentList(QStringLiteral("ReloadOrTryRestart"), argumentList);
    }

    inline QDBusPendingReply<> ResetFailed()
    {
        QList<QVariant> argumentList;
        return asyncCallWithArgumentList(QStringLiteral("ResetFailed"), argumentList);
    }

    inline QDBusPendingReply<QDBusObjectPath> Restart(const QString &mode)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(mode);
        return asyncCallWithArgumentList(QStringLiteral("Restart"), argumentList);
    }

    inline QDBusPendingReply<> SetProperties(bool runtime, const QList<QPair<QString, QVariant>> &properties)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(runtime) << QVariant::fromValue(properties);
        return asyncCallWithArgumentList(QStringLiteral("SetProperties"), argumentList);
    }

    inline QDBusPendingReply<QDBusObjectPath> Start(const QString &mode)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(mode);
        return asyncCallWithArgumentList(QStringLiteral("Start"), argumentList);
    }

    inline QDBusPendingReply<QDBusObjectPath> Stop(const QString &mode)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(mode);
        return asyncCallWithArgumentList(QStringLiteral("Stop"), argumentList);
    }

    inline QDBusPendingReply<> Thaw()
    {
        QList<QVariant> argumentList;
        return asyncCallWithArgumentList(QStringLiteral("Thaw"), argumentList);
    }

    inline QDBusPendingReply<QDBusObjectPath> TryRestart(const QString &mode)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(mode);
        return asyncCallWithArgumentList(QStringLiteral("TryRestart"), argumentList);
    }

    inline QDBusPendingReply<> Unref()
    {
        QList<QVariant> argumentList;
        return asyncCallWithArgumentList(QStringLiteral("Unref"), argumentList);
    }

Q_SIGNALS: // SIGNALS
public Q_SLOTS:
    void handlePropertiesChanged(const QString &iface, const QVariantMap &changedProps, const QStringList &invalidatedProps);
};

#endif
