// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from autotest.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include <QtTest>

#include <properties/BorderProperty.h>

#include "CreateTestInstances.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class TestBorderProperty : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void testEmpty()
    {
        BorderProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.left().has_value());
        QVERIFY(!property.right().has_value());
        QVERIFY(!property.top().has_value());
        QVERIFY(!property.bottom().has_value());
    }

    void testHasAnyValue()
    {
        BorderProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.hasAnyValue());

        {
            // Assigning an empty value to a property should have no effect.
            property.setLeft(LineProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setLeft(testLinePropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setLeft(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setRight(LineProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setRight(testLinePropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setRight(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setTop(LineProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setTop(testLinePropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setTop(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setBottom(LineProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setBottom(testLinePropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setBottom(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
    }

    void testResolveProperties()
    {
        BorderProperty source;
        BorderProperty destination;

        QVERIFY(!source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        // Calling resolve on empty source and destination should have no effect.
        BorderProperty::resolveProperties(source, destination);

        QVERIFY(!destination.hasAnyValue());

        source.setLeft(testLinePropertyInstance());
        source.setRight(testLinePropertyInstance());
        source.setTop(testLinePropertyInstance());
        source.setBottom(testLinePropertyInstance());

        QVERIFY(source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        BorderProperty::resolveProperties(source, destination);

        QVERIFY(destination.hasAnyValue());

        QCOMPARE(destination.left(), source.left());
        QCOMPARE(destination.right(), source.right());
        QCOMPARE(destination.top(), source.top());
        QCOMPARE(destination.bottom(), source.bottom());
    }
};

QTEST_MAIN(TestBorderProperty)

#include "TestBorderProperty.moc"