// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from autotest.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include <QtTest>

#include <properties/IconProperty.h>

#include "CreateTestInstances.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class TestIconProperty : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void testEmpty()
    {
        IconProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.alignment().has_value());
        QVERIFY(!property.width().has_value());
        QVERIFY(!property.height().has_value());
        QVERIFY(!property.name().has_value());
        QVERIFY(!property.source().has_value());
        QVERIFY(!property.color().has_value());
    }

    void testHasAnyValue()
    {
        IconProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.hasAnyValue());

        {
            // Assigning an empty value to a property should have no effect.
            property.setAlignment(AlignmentProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setAlignment(testAlignmentPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setAlignment(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            qreal value;
            property.setWidth(value);
            QVERIFY(property.hasAnyValue());
            property.setWidth(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            qreal value;
            property.setHeight(value);
            QVERIFY(property.hasAnyValue());
            property.setHeight(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            QString value;
            property.setName(value);
            QVERIFY(property.hasAnyValue());
            property.setName(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            QUrl value;
            property.setSource(value);
            QVERIFY(property.hasAnyValue());
            property.setSource(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            Union::Color value;
            property.setColor(value);
            QVERIFY(property.hasAnyValue());
            property.setColor(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
    }

    void testResolveProperties()
    {
        IconProperty source;
        IconProperty destination;

        QVERIFY(!source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        // Calling resolve on empty source and destination should have no effect.
        IconProperty::resolveProperties(source, destination);

        QVERIFY(!destination.hasAnyValue());

        source.setAlignment(testAlignmentPropertyInstance());
        source.setWidth(qreal{});
        source.setHeight(qreal{});
        source.setName(QString{});
        source.setSource(QUrl{});
        source.setColor(Union::Color{});

        QVERIFY(source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        IconProperty::resolveProperties(source, destination);

        QVERIFY(destination.hasAnyValue());

        QCOMPARE(destination.alignment(), source.alignment());
        QCOMPARE(destination.width(), source.width());
        QCOMPARE(destination.height(), source.height());
        QCOMPARE(destination.name(), source.name());
        QCOMPARE(destination.source(), source.source());
        QCOMPARE(destination.color(), source.color());
    }
};

QTEST_MAIN(TestIconProperty)

#include "TestIconProperty.moc"