// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from autotest.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include <QtTest>

#include <properties/OffsetProperty.h>

#include "CreateTestInstances.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class TestOffsetProperty : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void testEmpty()
    {
        OffsetProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.horizontal().has_value());
        QVERIFY(!property.vertical().has_value());
    }

    void testHasAnyValue()
    {
        OffsetProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.hasAnyValue());

        {
            qreal value;
            property.setHorizontal(value);
            QVERIFY(property.hasAnyValue());
            property.setHorizontal(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            qreal value;
            property.setVertical(value);
            QVERIFY(property.hasAnyValue());
            property.setVertical(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
    }

    void testResolveProperties()
    {
        OffsetProperty source;
        OffsetProperty destination;

        QVERIFY(!source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        // Calling resolve on empty source and destination should have no effect.
        OffsetProperty::resolveProperties(source, destination);

        QVERIFY(!destination.hasAnyValue());

        source.setHorizontal(qreal{});
        source.setVertical(qreal{});

        QVERIFY(source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        OffsetProperty::resolveProperties(source, destination);

        QVERIFY(destination.hasAnyValue());

        QCOMPARE(destination.horizontal(), source.horizontal());
        QCOMPARE(destination.vertical(), source.vertical());
    }
};

QTEST_MAIN(TestOffsetProperty)

#include "TestOffsetProperty.moc"