// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from autotest.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include <QtTest>

#include <properties/StyleProperty.h>

#include "CreateTestInstances.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class TestStyleProperty : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void testEmpty()
    {
        StyleProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.layout().has_value());
        QVERIFY(!property.text().has_value());
        QVERIFY(!property.icon().has_value());
        QVERIFY(!property.background().has_value());
        QVERIFY(!property.border().has_value());
        QVERIFY(!property.outline().has_value());
        QVERIFY(!property.corners().has_value());
        QVERIFY(!property.shadow().has_value());
    }

    void testHasAnyValue()
    {
        StyleProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.hasAnyValue());

        {
            // Assigning an empty value to a property should have no effect.
            property.setLayout(LayoutProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setLayout(testLayoutPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setLayout(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setText(TextProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setText(testTextPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setText(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setIcon(IconProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setIcon(testIconPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setIcon(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setBackground(BackgroundProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setBackground(testBackgroundPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setBackground(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setBorder(BorderProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setBorder(testBorderPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setBorder(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setOutline(OutlineProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setOutline(testOutlinePropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setOutline(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setCorners(CornersProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setCorners(testCornersPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setCorners(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setShadow(ShadowProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setShadow(testShadowPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setShadow(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
    }

    void testResolveProperties()
    {
        StyleProperty source;
        StyleProperty destination;

        QVERIFY(!source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        // Calling resolve on empty source and destination should have no effect.
        StyleProperty::resolveProperties(source, destination);

        QVERIFY(!destination.hasAnyValue());

        source.setLayout(testLayoutPropertyInstance());
        source.setText(testTextPropertyInstance());
        source.setIcon(testIconPropertyInstance());
        source.setBackground(testBackgroundPropertyInstance());
        source.setBorder(testBorderPropertyInstance());
        source.setOutline(testOutlinePropertyInstance());
        source.setCorners(testCornersPropertyInstance());
        source.setShadow(testShadowPropertyInstance());

        QVERIFY(source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        StyleProperty::resolveProperties(source, destination);

        QVERIFY(destination.hasAnyValue());

        QCOMPARE(destination.layout(), source.layout());
        QCOMPARE(destination.text(), source.text());
        QCOMPARE(destination.icon(), source.icon());
        QCOMPARE(destination.background(), source.background());
        QCOMPARE(destination.border(), source.border());
        QCOMPARE(destination.outline(), source.outline());
        QCOMPARE(destination.corners(), source.corners());
        QCOMPARE(destination.shadow(), source.shadow());
    }
};

QTEST_MAIN(TestStyleProperty)

#include "TestStyleProperty.moc"