// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from CreateTestInstances.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

#include <QtTest>

#include <properties/AlignmentProperty.h>
#include <properties/BackgroundProperty.h>
#include <properties/BorderProperty.h>
#include <properties/CornerProperty.h>
#include <properties/CornersProperty.h>
#include <properties/IconProperty.h>
#include <properties/ImageProperty.h>
#include <properties/LayoutProperty.h>
#include <properties/LineProperty.h>
#include <properties/OffsetProperty.h>
#include <properties/OutlineProperty.h>
#include <properties/ShadowProperty.h>
#include <properties/SizeProperty.h>
#include <properties/StyleProperty.h>
#include <properties/TextProperty.h>

using namespace Qt::StringLiterals;

namespace Union
{
namespace Properties
{

QColor testQColorInstance()
{
    return Qt::magenta;
}

qreal testQrealInstance()
{
    return 10.0;
}

QFont testQFontInstance()
{
    return QFont{u"Noto Sans"_s, 12};
}

StyleProperty testStylePropertyInstance();
LayoutProperty testLayoutPropertyInstance();
AlignmentProperty testAlignmentPropertyInstance();
SizeProperty testSizePropertyInstance();
TextProperty testTextPropertyInstance();
IconProperty testIconPropertyInstance();
BackgroundProperty testBackgroundPropertyInstance();
ImageProperty testImagePropertyInstance();
BorderProperty testBorderPropertyInstance();
LineProperty testLinePropertyInstance();
OutlineProperty testOutlinePropertyInstance();
CornersProperty testCornersPropertyInstance();
CornerProperty testCornerPropertyInstance();
ShadowProperty testShadowPropertyInstance();
OffsetProperty testOffsetPropertyInstance();

StyleProperty testStylePropertyInstance()
{
    StyleProperty instance;

    instance.setLayout(testLayoutPropertyInstance());
    instance.setText(testTextPropertyInstance());
    instance.setIcon(testIconPropertyInstance());
    instance.setBackground(testBackgroundPropertyInstance());
    instance.setBorder(testBorderPropertyInstance());
    instance.setOutline(testOutlinePropertyInstance());
    instance.setCorners(testCornersPropertyInstance());
    instance.setShadow(testShadowPropertyInstance());

    return instance;
}

LayoutProperty testLayoutPropertyInstance()
{
    LayoutProperty instance;

    instance.setAlignment(testAlignmentPropertyInstance());
    instance.setWidth(testQrealInstance());
    instance.setHeight(testQrealInstance());
    instance.setSpacing(testQrealInstance());
    instance.setPadding(testSizePropertyInstance());
    instance.setInset(testSizePropertyInstance());
    instance.setMargins(testSizePropertyInstance());

    return instance;
}

AlignmentProperty testAlignmentPropertyInstance()
{
    AlignmentProperty instance;

    instance.setContainer(Union::Properties::AlignmentContainer{});
    instance.setHorizontal(Union::Properties::Alignment{});
    instance.setVertical(Union::Properties::Alignment{});
    instance.setOrder(int{});

    return instance;
}

SizeProperty testSizePropertyInstance()
{
    SizeProperty instance;

    instance.setLeft(testQrealInstance());
    instance.setRight(testQrealInstance());
    instance.setTop(testQrealInstance());
    instance.setBottom(testQrealInstance());

    return instance;
}

TextProperty testTextPropertyInstance()
{
    TextProperty instance;

    instance.setAlignment(testAlignmentPropertyInstance());
    instance.setFont(testQFontInstance());
    instance.setColor(Union::Color{});

    return instance;
}

IconProperty testIconPropertyInstance()
{
    IconProperty instance;

    instance.setAlignment(testAlignmentPropertyInstance());
    instance.setWidth(testQrealInstance());
    instance.setHeight(testQrealInstance());
    instance.setName(QString{});
    instance.setSource(QUrl{});
    instance.setColor(Union::Color{});

    return instance;
}

BackgroundProperty testBackgroundPropertyInstance()
{
    BackgroundProperty instance;

    instance.setColor(Union::Color{});
    instance.setImage(testImagePropertyInstance());

    return instance;
}

ImageProperty testImagePropertyInstance()
{
    ImageProperty instance;

    instance.setImageData(QImage{});
    instance.setWidth(testQrealInstance());
    instance.setHeight(testQrealInstance());
    instance.setXOffset(testQrealInstance());
    instance.setYOffset(testQrealInstance());
    instance.setFlags(Union::Properties::ImageFlags{});
    instance.setMaskColor(Union::Color{});

    return instance;
}

BorderProperty testBorderPropertyInstance()
{
    BorderProperty instance;

    instance.setLeft(testLinePropertyInstance());
    instance.setRight(testLinePropertyInstance());
    instance.setTop(testLinePropertyInstance());
    instance.setBottom(testLinePropertyInstance());

    return instance;
}

LineProperty testLinePropertyInstance()
{
    LineProperty instance;

    instance.setSize(testQrealInstance());
    instance.setColor(Union::Color{});
    instance.setStyle(Union::Properties::LineStyle{});
    instance.setImage(testImagePropertyInstance());

    return instance;
}

OutlineProperty testOutlinePropertyInstance()
{
    OutlineProperty instance;

    instance.setLeft(testLinePropertyInstance());
    instance.setRight(testLinePropertyInstance());
    instance.setTop(testLinePropertyInstance());
    instance.setBottom(testLinePropertyInstance());

    return instance;
}

CornersProperty testCornersPropertyInstance()
{
    CornersProperty instance;

    instance.setTopLeft(testCornerPropertyInstance());
    instance.setTopRight(testCornerPropertyInstance());
    instance.setBottomLeft(testCornerPropertyInstance());
    instance.setBottomRight(testCornerPropertyInstance());

    return instance;
}

CornerProperty testCornerPropertyInstance()
{
    CornerProperty instance;

    instance.setRadius(testQrealInstance());
    instance.setWidth(testQrealInstance());
    instance.setHeight(testQrealInstance());
    instance.setColor(Union::Color{});
    instance.setImage(testImagePropertyInstance());

    return instance;
}

ShadowProperty testShadowPropertyInstance()
{
    ShadowProperty instance;

    instance.setOffset(testOffsetPropertyInstance());
    instance.setColor(Union::Color{});
    instance.setSize(testQrealInstance());
    instance.setBlur(testQrealInstance());
    instance.setLeft(testLinePropertyInstance());
    instance.setRight(testLinePropertyInstance());
    instance.setTop(testLinePropertyInstance());
    instance.setBottom(testLinePropertyInstance());
    instance.setTopLeft(testCornerPropertyInstance());
    instance.setTopRight(testCornerPropertyInstance());
    instance.setBottomLeft(testCornerPropertyInstance());
    instance.setBottomRight(testCornerPropertyInstance());

    return instance;
}

OffsetProperty testOffsetPropertyInstance()
{
    OffsetProperty instance;

    instance.setHorizontal(testQrealInstance());
    instance.setVertical(testQrealInstance());

    return instance;
}
}
}