// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from autotest.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include <QtTest>

#include <properties/AlignmentProperty.h>

#include "CreateTestInstances.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class TestAlignmentProperty : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void testEmpty()
    {
        AlignmentProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.container().has_value());
        QVERIFY(!property.horizontal().has_value());
        QVERIFY(!property.vertical().has_value());
        QVERIFY(!property.order().has_value());
    }

    void testHasAnyValue()
    {
        AlignmentProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.hasAnyValue());

        {
            Union::Properties::AlignmentContainer value;
            property.setContainer(value);
            QVERIFY(property.hasAnyValue());
            property.setContainer(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            Union::Properties::Alignment value;
            property.setHorizontal(value);
            QVERIFY(property.hasAnyValue());
            property.setHorizontal(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            Union::Properties::Alignment value;
            property.setVertical(value);
            QVERIFY(property.hasAnyValue());
            property.setVertical(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            int value;
            property.setOrder(value);
            QVERIFY(property.hasAnyValue());
            property.setOrder(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
    }

    void testResolveProperties()
    {
        AlignmentProperty source;
        AlignmentProperty destination;

        QVERIFY(!source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        // Calling resolve on empty source and destination should have no effect.
        AlignmentProperty::resolveProperties(source, destination);

        QVERIFY(!destination.hasAnyValue());

        source.setContainer(Union::Properties::AlignmentContainer{});
        source.setHorizontal(Union::Properties::Alignment{});
        source.setVertical(Union::Properties::Alignment{});
        source.setOrder(int{});

        QVERIFY(source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        AlignmentProperty::resolveProperties(source, destination);

        QVERIFY(destination.hasAnyValue());

        QCOMPARE(destination.container(), source.container());
        QCOMPARE(destination.horizontal(), source.horizontal());
        QCOMPARE(destination.vertical(), source.vertical());
        QCOMPARE(destination.order(), source.order());
    }
};

QTEST_MAIN(TestAlignmentProperty)

#include "TestAlignmentProperty.moc"