// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from autotest.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include <QtTest>

#include <properties/CornersProperty.h>

#include "CreateTestInstances.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class TestCornersProperty : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void testEmpty()
    {
        CornersProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.topLeft().has_value());
        QVERIFY(!property.topRight().has_value());
        QVERIFY(!property.bottomLeft().has_value());
        QVERIFY(!property.bottomRight().has_value());
    }

    void testHasAnyValue()
    {
        CornersProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.hasAnyValue());

        {
            // Assigning an empty value to a property should have no effect.
            property.setTopLeft(CornerProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setTopLeft(testCornerPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setTopLeft(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setTopRight(CornerProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setTopRight(testCornerPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setTopRight(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setBottomLeft(CornerProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setBottomLeft(testCornerPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setBottomLeft(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setBottomRight(CornerProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setBottomRight(testCornerPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setBottomRight(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
    }

    void testResolveProperties()
    {
        CornersProperty source;
        CornersProperty destination;

        QVERIFY(!source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        // Calling resolve on empty source and destination should have no effect.
        CornersProperty::resolveProperties(source, destination);

        QVERIFY(!destination.hasAnyValue());

        source.setTopLeft(testCornerPropertyInstance());
        source.setTopRight(testCornerPropertyInstance());
        source.setBottomLeft(testCornerPropertyInstance());
        source.setBottomRight(testCornerPropertyInstance());

        QVERIFY(source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        CornersProperty::resolveProperties(source, destination);

        QVERIFY(destination.hasAnyValue());

        QCOMPARE(destination.topLeft(), source.topLeft());
        QCOMPARE(destination.topRight(), source.topRight());
        QCOMPARE(destination.bottomLeft(), source.bottomLeft());
        QCOMPARE(destination.bottomRight(), source.bottomRight());
    }
};

QTEST_MAIN(TestCornersProperty)

#include "TestCornersProperty.moc"