// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from autotest.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include <QtTest>

#include <properties/ShadowProperty.h>

#include "CreateTestInstances.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class TestShadowProperty : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void testEmpty()
    {
        ShadowProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.offset().has_value());
        QVERIFY(!property.color().has_value());
        QVERIFY(!property.size().has_value());
        QVERIFY(!property.blur().has_value());
        QVERIFY(!property.left().has_value());
        QVERIFY(!property.right().has_value());
        QVERIFY(!property.top().has_value());
        QVERIFY(!property.bottom().has_value());
        QVERIFY(!property.topLeft().has_value());
        QVERIFY(!property.topRight().has_value());
        QVERIFY(!property.bottomLeft().has_value());
        QVERIFY(!property.bottomRight().has_value());
    }

    void testHasAnyValue()
    {
        ShadowProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.hasAnyValue());

        {
            // Assigning an empty value to a property should have no effect.
            property.setOffset(OffsetProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setOffset(testOffsetPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setOffset(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            Union::Color value;
            property.setColor(value);
            QVERIFY(property.hasAnyValue());
            property.setColor(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            qreal value;
            property.setSize(value);
            QVERIFY(property.hasAnyValue());
            property.setSize(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            qreal value;
            property.setBlur(value);
            QVERIFY(property.hasAnyValue());
            property.setBlur(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setLeft(LineProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setLeft(testLinePropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setLeft(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setRight(LineProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setRight(testLinePropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setRight(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setTop(LineProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setTop(testLinePropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setTop(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setBottom(LineProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setBottom(testLinePropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setBottom(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setTopLeft(CornerProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setTopLeft(testCornerPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setTopLeft(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setTopRight(CornerProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setTopRight(testCornerPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setTopRight(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setBottomLeft(CornerProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setBottomLeft(testCornerPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setBottomLeft(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            // Assigning an empty value to a property should have no effect.
            property.setBottomRight(CornerProperty{});
            QVERIFY(!property.hasAnyValue());

            property.setBottomRight(testCornerPropertyInstance());
            QVERIFY(property.hasAnyValue());

            property.setBottomRight(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
    }

    void testResolveProperties()
    {
        ShadowProperty source;
        ShadowProperty destination;

        QVERIFY(!source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        // Calling resolve on empty source and destination should have no effect.
        ShadowProperty::resolveProperties(source, destination);

        QVERIFY(!destination.hasAnyValue());

        source.setOffset(testOffsetPropertyInstance());
        source.setColor(Union::Color{});
        source.setSize(qreal{});
        source.setBlur(qreal{});
        source.setLeft(testLinePropertyInstance());
        source.setRight(testLinePropertyInstance());
        source.setTop(testLinePropertyInstance());
        source.setBottom(testLinePropertyInstance());
        source.setTopLeft(testCornerPropertyInstance());
        source.setTopRight(testCornerPropertyInstance());
        source.setBottomLeft(testCornerPropertyInstance());
        source.setBottomRight(testCornerPropertyInstance());

        QVERIFY(source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        ShadowProperty::resolveProperties(source, destination);

        QVERIFY(destination.hasAnyValue());

        QCOMPARE(destination.offset(), source.offset());
        QCOMPARE(destination.color(), source.color());
        QCOMPARE(destination.size(), source.size());
        QCOMPARE(destination.blur(), source.blur());
        QCOMPARE(destination.left(), source.left());
        QCOMPARE(destination.right(), source.right());
        QCOMPARE(destination.top(), source.top());
        QCOMPARE(destination.bottom(), source.bottom());
        QCOMPARE(destination.topLeft(), source.topLeft());
        QCOMPARE(destination.topRight(), source.topRight());
        QCOMPARE(destination.bottomLeft(), source.bottomLeft());
        QCOMPARE(destination.bottomRight(), source.bottomRight());
    }
};

QTEST_MAIN(TestShadowProperty)

#include "TestShadowProperty.moc"