// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from autotest.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include <QtTest>

#include <properties/SizeProperty.h>

#include "CreateTestInstances.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class TestSizeProperty : public QObject
{
    Q_OBJECT
private Q_SLOTS:
    void testEmpty()
    {
        SizeProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.left().has_value());
        QVERIFY(!property.right().has_value());
        QVERIFY(!property.top().has_value());
        QVERIFY(!property.bottom().has_value());
    }

    void testHasAnyValue()
    {
        SizeProperty property;

        // An empty instance should not have any values for its properties.
        QVERIFY(!property.hasAnyValue());

        {
            qreal value;
            property.setLeft(value);
            QVERIFY(property.hasAnyValue());
            property.setLeft(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            qreal value;
            property.setRight(value);
            QVERIFY(property.hasAnyValue());
            property.setRight(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            qreal value;
            property.setTop(value);
            QVERIFY(property.hasAnyValue());
            property.setTop(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
        {
            qreal value;
            property.setBottom(value);
            QVERIFY(property.hasAnyValue());
            property.setBottom(std::nullopt);
            QVERIFY(!property.hasAnyValue());
        }
    }

    void testResolveProperties()
    {
        SizeProperty source;
        SizeProperty destination;

        QVERIFY(!source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        // Calling resolve on empty source and destination should have no effect.
        SizeProperty::resolveProperties(source, destination);

        QVERIFY(!destination.hasAnyValue());

        source.setLeft(qreal{});
        source.setRight(qreal{});
        source.setTop(qreal{});
        source.setBottom(qreal{});

        QVERIFY(source.hasAnyValue());
        QVERIFY(!destination.hasAnyValue());

        SizeProperty::resolveProperties(source, destination);

        QVERIFY(destination.hasAnyValue());

        QCOMPARE(destination.left(), source.left());
        QCOMPARE(destination.right(), source.right());
        QCOMPARE(destination.top(), source.top());
        QCOMPARE(destination.bottom(), source.bottom());
    }
};

QTEST_MAIN(TestSizeProperty)

#include "TestSizeProperty.moc"